/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging.unitofwork;

import org.axonframework.common.transaction.Transaction;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

class SpringTransactionManagerTest {
    private SpringTransactionManager testSubject;
    private PlatformTransactionManager transactionManager;
    private TransactionStatus underlyingTransactionStatus;

    SpringTransactionManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.underlyingTransactionStatus = (TransactionStatus)Mockito.mock(TransactionStatus.class);
        this.transactionManager = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        this.testSubject = new SpringTransactionManager(this.transactionManager);
        Mockito.when((Object)this.transactionManager.getTransaction((TransactionDefinition)Mockito.isA(TransactionDefinition.class))).thenReturn((Object)this.underlyingTransactionStatus);
        Mockito.when((Object)this.underlyingTransactionStatus.isNewTransaction()).thenReturn((Object)true);
    }

    @Test
    void manageTransaction_CustomTransactionStatus() {
        this.testSubject = new SpringTransactionManager(this.transactionManager, (TransactionDefinition)Mockito.mock(TransactionDefinition.class));
        this.testSubject.startTransaction().commit();
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager)).getTransaction((TransactionDefinition)Mockito.any());
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager)).commit(this.underlyingTransactionStatus);
    }

    @Test
    void manageTransaction_DefaultTransactionStatus() {
        this.testSubject.startTransaction().commit();
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager)).getTransaction((TransactionDefinition)Mockito.isA(DefaultTransactionDefinition.class));
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager)).commit(this.underlyingTransactionStatus);
    }

    @Test
    void commitTransaction_NoCommitOnInactiveTransaction() {
        Transaction transaction = this.testSubject.startTransaction();
        Mockito.when((Object)this.underlyingTransactionStatus.isCompleted()).thenReturn((Object)true);
        transaction.commit();
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).commit(this.underlyingTransactionStatus);
    }

    @Test
    void commitTransaction_NoRollbackOnInactiveTransaction() {
        Transaction transaction = this.testSubject.startTransaction();
        Mockito.when((Object)this.underlyingTransactionStatus.isCompleted()).thenReturn((Object)true);
        transaction.rollback();
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).rollback(this.underlyingTransactionStatus);
    }

    @Test
    void commitTransaction_NoCommitOnNestedTransaction() {
        Transaction transaction = this.testSubject.startTransaction();
        Mockito.when((Object)this.underlyingTransactionStatus.isNewTransaction()).thenReturn((Object)false);
        transaction.commit();
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).commit(this.underlyingTransactionStatus);
    }

    @Test
    void commitTransaction_NoRollbackOnNestedTransaction() {
        Transaction transaction = this.testSubject.startTransaction();
        Mockito.when((Object)this.underlyingTransactionStatus.isNewTransaction()).thenReturn((Object)false);
        transaction.rollback();
        ((PlatformTransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).rollback(this.underlyingTransactionStatus);
    }
}

