/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.modeling.command;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.common.legacyjpa.SimpleEntityManagerProvider;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.LockAwareAggregate;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.legacyjpa.GenericJpaRepository;
import org.axonframework.spring.modeling.command.JpaAggregate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
@ContextConfiguration(classes={TestContext.class})
@TestPropertySource(value={"classpath:hsqldb.database.properties"})
@Transactional
class GenericJpaRepositoryIntegrationTest
implements EventMessageHandler {
    private final List<EventMessage> capturedEvents = new ArrayList<EventMessage>();
    @Autowired
    @Qualifier(value="simpleRepository")
    private GenericJpaRepository<JpaAggregate> repository;
    @Autowired
    private EventBus eventBus;
    @PersistenceContext
    private EntityManager entityManager;
    private SubscribingEventProcessor eventProcessor;

    GenericJpaRepositoryIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        SimpleEventHandlerInvoker eventHandlerInvoker = SimpleEventHandlerInvoker.builder().eventHandlers(new Object[]{this}).build();
        this.eventProcessor = SubscribingEventProcessor.builder().name("test").eventHandlerInvoker((EventHandlerInvoker)eventHandlerInvoker).messageSource((SubscribableMessageSource)this.eventBus).build();
        this.eventProcessor.start();
    }

    @AfterEach
    void tearDown() {
        this.eventProcessor.shutDown();
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void storeAndLoadNewAggregate() throws Exception {
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        String originalId = (String)((LockAwareAggregate)this.repository.newInstance(() -> new JpaAggregate("Hello"))).invoke(JpaAggregate::getIdentifier);
        uow.commit();
        this.entityManager.flush();
        this.entityManager.clear();
        List results = this.entityManager.createQuery("SELECT a FROM JpaAggregate a").getResultList();
        Assertions.assertEquals((int)1, (int)results.size());
        JpaAggregate aggregate = (JpaAggregate)results.get(0);
        Assertions.assertEquals((Object)originalId, (Object)aggregate.getIdentifier());
        uow = this.startAndGetUnitOfWork();
        Aggregate storedAggregate = this.repository.load(originalId);
        uow.commit();
        Assertions.assertEquals((Object)storedAggregate.identifierAsString(), (Object)originalId);
        Assertions.assertTrue((boolean)this.capturedEvents.isEmpty());
    }

    @Test
    void updateAnAggregate() {
        JpaAggregate agg = new JpaAggregate("First message");
        this.entityManager.persist((Object)agg);
        this.entityManager.flush();
        this.entityManager.clear();
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        Aggregate aggregate = this.repository.load(agg.getIdentifier());
        aggregate.execute(r -> r.setMessage("And again"));
        aggregate.execute(r -> r.setMessage("And more"));
        uow.commit();
        Assertions.assertEquals((Long)1L, (Long)aggregate.version());
        Assertions.assertEquals((int)2, (int)this.capturedEvents.size());
        Assertions.assertNotNull((Object)this.entityManager.find(JpaAggregate.class, (Object)aggregate.identifierAsString()));
    }

    @Test
    void deleteAnAggregate() {
        JpaAggregate agg = new JpaAggregate("First message");
        this.entityManager.persist((Object)agg);
        this.entityManager.flush();
        this.entityManager.clear();
        Assertions.assertEquals((Long)0L, (Long)agg.getVersion());
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        Aggregate aggregate = this.repository.load(agg.getIdentifier());
        aggregate.execute(r -> r.setMessage("And again"));
        aggregate.execute(r -> r.setMessage("And more"));
        aggregate.execute(JpaAggregate::delete);
        uow.commit();
        this.entityManager.flush();
        this.entityManager.clear();
        Assertions.assertEquals((int)2, (int)this.capturedEvents.size());
        Assertions.assertNull((Object)this.entityManager.find(JpaAggregate.class, (Object)aggregate.identifierAsString()));
    }

    public Object handle(EventMessage event) {
        this.capturedEvents.add(event);
        return null;
    }

    private UnitOfWork<?> startAndGetUnitOfWork() {
        return DefaultUnitOfWork.startAndGet(null);
    }

    @Configuration
    public static class TestContext {
        @Bean
        public DataSource dataSource(@Value(value="${jdbc.driverclass}") String driverClass, @Value(value="${jdbc.url}") String url, @Value(value="${jdbc.username}") String username, @Value(value="${jdbc.password}") String password) {
            DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(url, username, password);
            driverManagerDataSource.setDriverClassName(driverClass);
            return (DataSource)Mockito.spy((Object)driverManagerDataSource);
        }

        @Bean(value={"entityManagerFactory"})
        public LocalContainerEntityManagerFactoryBean entityManagerFactory(@Value(value="${hibernate.sql.dialect}") String dialect, @Value(value="${hibernate.sql.generateddl}") boolean generateDdl, @Value(value="${hibernate.sql.show}") boolean showSql, DataSource dataSource) {
            LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
            entityManagerFactoryBean.setPersistenceUnitName("AxonSpringTest");
            HibernateJpaVendorAdapter jpaVendorAdapter = new HibernateJpaVendorAdapter();
            jpaVendorAdapter.setDatabasePlatform(dialect);
            jpaVendorAdapter.setGenerateDdl(generateDdl);
            jpaVendorAdapter.setShowSql(showSql);
            entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)jpaVendorAdapter);
            entityManagerFactoryBean.setDataSource(dataSource);
            return entityManagerFactoryBean;
        }

        @Bean
        @DependsOn(value={"entityManagerFactory"})
        public JpaTransactionManager transactionManager(EntityManagerFactory entityManagerFactory, DataSource dataSource) {
            JpaTransactionManager jpaTransactionManager = new JpaTransactionManager(entityManagerFactory);
            jpaTransactionManager.setDataSource(dataSource);
            return jpaTransactionManager;
        }

        @Bean
        public PersistenceAnnotationBeanPostProcessor persistenceAnnotationBeanPostProcessor() {
            return new PersistenceAnnotationBeanPostProcessor();
        }

        @Bean(value={"mockEventBus"})
        public EventBus mockEventBus() {
            return (EventBus)Mockito.mock(EventBus.class);
        }

        @Bean
        public EventBus eventBus() {
            return SimpleEventBus.builder().build();
        }

        @Bean(value={"simpleRepository"})
        public Repository<JpaAggregate> simpleRepository(EntityManagerProvider entityManagerProvider, EventBus eventBus) {
            return GenericJpaRepository.builder(JpaAggregate.class).entityManagerProvider(entityManagerProvider).eventBus(eventBus).build();
        }

        @Configuration
        public static class PersistenceConfig {
            @PersistenceContext
            private EntityManager entityManager;

            @Bean
            public EntityManagerProvider entityManagerProvider() {
                return new SimpleEntityManagerProvider(this.entityManager);
            }
        }
    }
}

