/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.modeling.command;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Version;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.AggregateVersion;
import org.axonframework.spring.utils.StubDomainEvent;

@Entity
public class JpaAggregate {
    @AggregateIdentifier
    @Id
    private String id;
    @AggregateVersion
    @Version
    private Long version;
    @Basic
    private String message;

    public JpaAggregate(String message) {
        this.id = IdentifierFactory.getInstance().generateIdentifier();
        this.message = message;
    }

    protected JpaAggregate() {
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
        AggregateLifecycle.apply((Object)new StubDomainEvent(this.message));
    }

    public void delete() {
        AggregateLifecycle.markDeleted();
    }

    public String getIdentifier() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }
}

