/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.saga;

import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.spring.saga.SpringResourceInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class SpringResourceInjectorTest {
    private static ResourceInjector testSubject;

    @BeforeAll
    static void beforeClass() {
        AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(new Class[]{Context.class});
        testSubject = (ResourceInjector)appCtx.getBean(ResourceInjector.class);
    }

    @Test
    void injectSaga() {
        InjectableSaga injectableSaga = new InjectableSaga();
        testSubject.injectResources((Object)injectableSaga);
        Assertions.assertNotNull((Object)injectableSaga.getCommandBus());
        Assertions.assertNull((Object)injectableSaga.getNonAnnotatedCommandBus());
        Assertions.assertNull((Object)injectableSaga.getEventBus());
    }

    @Test
    void resourcesNotAvailable() {
        ProblematicInjectableSaga injectableSaga = new ProblematicInjectableSaga();
        Assertions.assertThrows(BeanCreationException.class, () -> testSubject.injectResources((Object)injectableSaga));
    }

    @Configuration
    public static class Context {
        @Bean
        public ResourceInjector resourceInjector() {
            return new SpringResourceInjector();
        }

        @Bean
        public CommandBus commandBus() {
            return SimpleCommandBus.builder().build();
        }
    }

    public static class ProblematicInjectableSaga
    extends InjectableSaga {
        private static final long serialVersionUID = 3731262948334502511L;

        @Override
        @Autowired(required=true)
        public void setEventBus(EventBus eventBus) {
            throw new UnsupportedOperationException("Method not implemented");
        }
    }

    public static class InjectableSaga {
        private static final long serialVersionUID = 6273830321273396327L;
        @Autowired
        private CommandBus commandBus1;
        private CommandBus commandBus2;
        private EventBus eventBus;

        public CommandBus getCommandBus() {
            return this.commandBus1;
        }

        public CommandBus getNonAnnotatedCommandBus() {
            return this.commandBus2;
        }

        public EventBus getEventBus() {
            return this.eventBus;
        }

        @Autowired(required=false)
        public void setEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
        }
    }
}

