/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.utils;

import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.testcontainers.containers.MySQLContainer;

public class MysqlTestContainerExtension
extends MySQLContainer<MysqlTestContainerExtension>
implements BeforeAllCallback,
AfterAllCallback {
    private static MysqlTestContainerExtension container;

    public MysqlTestContainerExtension() {
        super("mysql:8.0");
    }

    public static MysqlTestContainerExtension getInstance() {
        if (container == null) {
            container = new MysqlTestContainerExtension();
        }
        return container;
    }

    public DataSource asDataSource() {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(container.getJdbcUrl(), container.getUsername(), container.getPassword());
        driverManagerDataSource.setDriverClassName(container.getDriverClassName());
        return driverManagerDataSource;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        MysqlTestContainerExtension.getInstance().start();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        MysqlTestContainerExtension.getInstance().stop();
    }
}

