/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

public sealed interface EventProcessorSettings {
    public static final String DEFAULT = "..default";

    @Nonnull
    public ProcessorMode processorMode();

    @Nullable
    public String source();

    public static non-sealed interface PooledEventProcessorSettings
    extends EventProcessorSettings {
        @Override
        @Nonnull
        default public ProcessorMode processorMode() {
            return ProcessorMode.POOLED;
        }

        public int initialSegmentCount();

        public long tokenClaimIntervalInMillis();

        public int threadCount();

        public int batchSize();

        @Nonnull
        public String tokenStore();
    }

    public static non-sealed interface SubscribingEventProcessorSettings
    extends EventProcessorSettings {
        @Override
        @Nonnull
        default public ProcessorMode processorMode() {
            return ProcessorMode.SUBSCRIBING;
        }
    }

    public static enum ProcessorMode {
        SUBSCRIBING,
        POOLED;

    }

    public record MapWrapper(Map<String, EventProcessorSettings> settings) {
    }
}

