/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.DescriptionUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class EventValidator
implements EventMessageHandler {
    private final List<EventMessage> publishedEvents = new ArrayList<EventMessage>();
    private final EventBus eventBus;
    private final FieldFilter fieldFilter;
    private boolean recording = false;

    public EventValidator(EventBus eventBus, FieldFilter fieldFilter) {
        this.eventBus = eventBus;
        this.fieldFilter = fieldFilter;
    }

    public void assertPublishedEventsMatching(Matcher<? extends Iterable<?>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            StringDescription expectedDescription = new StringDescription();
            StringDescription actualDescription = new StringDescription();
            matcher.describeTo((Description)expectedDescription);
            DescriptionUtils.describe(this.publishedEvents, (Description)actualDescription);
            throw new AxonAssertionError(String.format("Published events did not match.\nExpected:\n<%s>\n\nGot:\n<%s>\n", expectedDescription, actualDescription));
        }
    }

    public void assertPublishedEvents(Object ... expected) {
        if (this.publishedEvents.size() != expected.length) {
            throw new AxonAssertionError(String.format("Got wrong number of events published. Expected <%s>, got <%s>", expected.length, this.publishedEvents.size()));
        }
        this.assertPublishedEventsMatching(Matchers.payloadsMatching(Matchers.exactSequenceOf(this.createEqualToMatchers(expected))));
    }

    public Object handle(EventMessage event) {
        this.publishedEvents.add(event);
        return null;
    }

    public void startRecording() {
        if (!this.recording) {
            this.eventBus.subscribe(eventMessages -> eventMessages.forEach(this::handle));
            this.recording = true;
        }
    }

    private Matcher<Object>[] createEqualToMatchers(Object[] expected) {
        ArrayList<EqualFieldsMatcher<Object>> matchers = new ArrayList<EqualFieldsMatcher<Object>>(expected.length);
        for (Object event : expected) {
            matchers.add(Matchers.equalTo(this.unwrapEvent(event), this.fieldFilter));
        }
        return matchers.toArray(new Matcher[0]);
    }

    private Object unwrapEvent(Object event) {
        return event instanceof EventMessage ? ((EventMessage)event).getPayload() : event;
    }
}

