/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.Set;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.test.AxonAssertionError;

public class RepositoryContentValidator<T> {
    private final Class<T> sagaType;
    private final InMemorySagaStore sagaStore;

    RepositoryContentValidator(Class<T> sagaType, InMemorySagaStore sagaStore) {
        this.sagaType = sagaType;
        this.sagaStore = sagaStore;
    }

    public void assertAssociationPresent(String associationKey, String associationValue) {
        Set associatedSagas = this.sagaStore.findSagas(this.sagaType, new AssociationValue(associationKey, associationValue));
        if (associatedSagas.isEmpty()) {
            throw new AxonAssertionError(String.format("Expected a saga to be associated with key:<%s> value:<%s>, but found <none>", associationKey, associationValue));
        }
    }

    public void assertNoAssociationPresent(String associationKey, String associationValue) {
        Set associatedSagas = this.sagaStore.findSagas(this.sagaType, new AssociationValue(associationKey, associationValue));
        if (!associatedSagas.isEmpty()) {
            throw new AxonAssertionError(String.format("Expected no sagas to be associated with key:<%s> value:<%s>, but found <%s>", associationKey, associationValue, associatedSagas.size()));
        }
    }

    public void assertActiveSagas(int expected) {
        if (expected != this.sagaStore.size()) {
            throw new AxonAssertionError(String.format("Wrong number of active sagas. Expected <%s>, got <%s>.", expected, this.sagaStore.size()));
        }
    }
}

