/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.test.utils.CallbackBehavior;
import org.axonframework.test.utils.DefaultCallbackBehavior;

public class RecordingCommandBus
implements CommandBus {
    private final ConcurrentMap<String, MessageHandler<? super CommandMessage<?>>> subscriptions = new ConcurrentHashMap();
    private final List<CommandMessage<?>> dispatchedCommands = new ArrayList();
    private CallbackBehavior callbackBehavior = new DefaultCallbackBehavior();

    public <C> void dispatch(CommandMessage<C> command) {
        this.dispatchedCommands.add(command);
    }

    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, ? super R> callback) {
        this.dispatchedCommands.add(command);
        try {
            callback.onResult(command, GenericCommandResultMessage.asCommandResultMessage((Object)this.callbackBehavior.handle(command.getPayload(), command.getMetaData())));
        }
        catch (Throwable throwable) {
            callback.onResult(command, GenericCommandResultMessage.asCommandResultMessage((Throwable)throwable));
        }
    }

    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        this.subscriptions.putIfAbsent(commandName, handler);
        return () -> this.subscriptions.remove(commandName, handler);
    }

    public void clearCommands() {
        this.dispatchedCommands.clear();
    }

    public void clearSubscriptions() {
        this.subscriptions.clear();
    }

    public boolean isSubscribed(MessageHandler<? super CommandMessage<?>> commandHandler) {
        return this.subscriptions.containsValue(commandHandler);
    }

    public <C> boolean isSubscribed(String commandName, MessageHandler<? super CommandMessage<?>> commandHandler) {
        return this.subscriptions.containsKey(commandName) && ((MessageHandler)this.subscriptions.get(commandName)).equals(commandHandler);
    }

    public Map<String, MessageHandler<? super CommandMessage<?>>> getSubscriptions() {
        return this.subscriptions;
    }

    public List<CommandMessage<?>> getDispatchedCommands() {
        return this.dispatchedCommands;
    }

    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.callbackBehavior = callbackBehavior;
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        return null;
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return () -> true;
    }
}

