/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing.opentelemetry;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.axonframework.tracing.Span;

public class OpenTelemetrySpan
implements Span {
    private final SpanBuilder spanBuilder;
    private final Deque<Scope> scopeQueue = new ArrayDeque<Scope>();
    private io.opentelemetry.api.trace.Span span = null;

    public OpenTelemetrySpan(SpanBuilder spanBuilder) {
        Objects.requireNonNull(spanBuilder, "Span builder can not be null!");
        this.spanBuilder = spanBuilder;
    }

    public Span start() {
        if (this.span == null) {
            this.span = this.spanBuilder.startSpan();
        }
        this.scopeQueue.addFirst(this.span.makeCurrent());
        return this;
    }

    public void end() {
        if (!this.scopeQueue.isEmpty()) {
            this.scopeQueue.remove().close();
        }
        if (this.scopeQueue.isEmpty()) {
            this.span.end();
        }
    }

    public Span recordException(Throwable t) {
        this.span.recordException(t);
        this.span.setStatus(StatusCode.ERROR, t.getMessage());
        return this;
    }
}

