/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka;

import io.cloudevents.kafka.CloudEventDeserializer;
import io.cloudevents.kafka.CloudEventSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.axonframework.extensions.kafka.eventhandling.producer.ConfirmationMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="axon.kafka")
public class KafkaProperties {
    public static final String DEFAULT_TOPIC = "Axon.Events";
    private List<String> bootstrapServers = new ArrayList<String>(Collections.singletonList("localhost:9092"));
    private String clientId;
    private String defaultTopic = "Axon.Events";
    private Map<String, String> properties = new HashMap<String, String>();
    private final Publisher publisher = new Publisher();
    private final Producer producer = new Producer();
    private final Fetcher fetcher = new Fetcher();
    private final Consumer consumer = new Consumer();
    private final Ssl ssl = new Ssl();
    private MessageConverterMode messageConverterMode = MessageConverterMode.DEFAULT;

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(List<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void put(String key, String value) {
        this.properties.put(key, value);
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public Fetcher getFetcher() {
        return this.fetcher;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setMessageConverterMode(MessageConverterMode messageConverterMode) {
        this.messageConverterMode = messageConverterMode;
    }

    public MessageConverterMode getMessageConverterMode() {
        return this.messageConverterMode;
    }

    private Map<String, Object> buildCommonProperties() {
        HashMap<String, Object> commonProperties = new HashMap<String, Object>();
        if (this.bootstrapServers != null) {
            commonProperties.put("bootstrap.servers", this.bootstrapServers);
        }
        if (this.clientId != null) {
            commonProperties.put("client.id", this.clientId);
        }
        KafkaProperties.addSslProperties(commonProperties, this.ssl);
        if (!CollectionUtils.isEmpty(this.properties)) {
            commonProperties.putAll(this.properties);
        }
        return commonProperties;
    }

    public Map<String, Object> buildConsumerProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.consumer.buildProperties(this.getMessageConverterMode()));
        return properties;
    }

    public Map<String, Object> buildProducerProperties() {
        Map<String, Object> producerProperties = this.buildCommonProperties();
        producerProperties.putAll(this.producer.buildProperties(this.getMessageConverterMode()));
        return producerProperties;
    }

    private static String resourceToPath(Resource resource) {
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Resource '" + resource + "' must be on a file system", ex);
        }
    }

    private static void addSslProperties(Map<String, Object> properties, Ssl ssl) {
        if (ssl.getKeyPassword() != null) {
            properties.put("ssl.key.password", ssl.getKeyPassword());
        }
        if (ssl.getKeystoreLocation() != null) {
            properties.put("ssl.keystore.location", KafkaProperties.resourceToPath(ssl.getKeystoreLocation()));
        }
        if (ssl.getKeystorePassword() != null) {
            properties.put("ssl.keystore.password", ssl.getKeystorePassword());
        }
        if (ssl.getTruststoreLocation() != null) {
            properties.put("ssl.truststore.location", KafkaProperties.resourceToPath(ssl.getTruststoreLocation()));
        }
        if (ssl.getTruststorePassword() != null) {
            properties.put("ssl.truststore.password", ssl.getTruststorePassword());
        }
    }

    public static class Ssl {
        private String keyPassword;
        private Resource keystoreLocation;
        private String keystorePassword;
        private Resource truststoreLocation;
        private String truststorePassword;

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public Resource getKeystoreLocation() {
            return this.keystoreLocation;
        }

        public void setKeystoreLocation(Resource keystoreLocation) {
            this.keystoreLocation = keystoreLocation;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public Resource getTruststoreLocation() {
            return this.truststoreLocation;
        }

        public void setTruststoreLocation(Resource truststoreLocation) {
            this.truststoreLocation = truststoreLocation;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }
    }

    public static enum MessageConverterMode {
        DEFAULT,
        CLOUD_EVENT;

    }

    public static enum EventProcessorMode {
        SUBSCRIBING,
        TRACKING,
        POOLED_STREAMING;

    }

    public static class Consumer {
        private final Ssl ssl = new Ssl();
        private Integer autoCommitInterval;
        private String autoOffsetReset;
        private List<String> bootstrapServers;
        private String clientId;
        private Boolean enableAutoCommit;
        private Integer fetchMaxWait;
        private Integer fetchMinSize;
        private Integer heartbeatInterval;
        private Class<?> keyDeserializer = StringDeserializer.class;
        private Class<?> valueDeserializer = ByteArrayDeserializer.class;
        private Integer maxPollRecords;
        private final Map<String, String> properties = new HashMap<String, String>();
        private EventProcessorMode eventProcessorMode = EventProcessorMode.TRACKING;

        public Ssl getSsl() {
            return this.ssl;
        }

        public Integer getAutoCommitInterval() {
            return this.autoCommitInterval;
        }

        public void setAutoCommitInterval(Integer autoCommitInterval) {
            this.autoCommitInterval = autoCommitInterval;
        }

        public String getAutoOffsetReset() {
            return this.autoOffsetReset;
        }

        public void setAutoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
        }

        public List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public Boolean getEnableAutoCommit() {
            return this.enableAutoCommit;
        }

        public void setEnableAutoCommit(Boolean enableAutoCommit) {
            this.enableAutoCommit = enableAutoCommit;
        }

        public Integer getFetchMaxWait() {
            return this.fetchMaxWait;
        }

        public void setFetchMaxWait(Integer fetchMaxWait) {
            this.fetchMaxWait = fetchMaxWait;
        }

        public Integer getFetchMinSize() {
            return this.fetchMinSize;
        }

        public void setFetchMinSize(Integer fetchMinSize) {
            this.fetchMinSize = fetchMinSize;
        }

        public Integer getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public void setHeartbeatInterval(Integer heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
        }

        public Class<?> getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public void setKeyDeserializer(Class<?> keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        public Class<?> getValueDeserializer() {
            return this.valueDeserializer;
        }

        public void setValueDeserializer(Class<?> valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
        }

        public Integer getMaxPollRecords() {
            return this.maxPollRecords;
        }

        public void setMaxPollRecords(Integer maxPollRecords) {
            this.maxPollRecords = maxPollRecords;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public EventProcessorMode getEventProcessorMode() {
            return this.eventProcessorMode;
        }

        public void setEventProcessorMode(EventProcessorMode eventProcessorMode) {
            this.eventProcessorMode = eventProcessorMode;
        }

        public Map<String, Object> buildProperties(MessageConverterMode messageConverterMode) {
            HashMap<String, Object> consumerProperties = new HashMap<String, Object>();
            if (this.autoCommitInterval != null) {
                consumerProperties.put("auto.commit.interval.ms", this.autoCommitInterval);
            }
            if (this.autoOffsetReset != null) {
                consumerProperties.put("auto.offset.reset", this.autoOffsetReset);
            }
            if (this.bootstrapServers != null) {
                consumerProperties.put("bootstrap.servers", this.bootstrapServers);
            }
            if (this.clientId != null) {
                consumerProperties.put("client.id", this.clientId);
            }
            if (this.enableAutoCommit != null) {
                consumerProperties.put("enable.auto.commit", this.enableAutoCommit);
            }
            if (this.fetchMaxWait != null) {
                consumerProperties.put("fetch.max.wait.ms", this.fetchMaxWait);
            }
            if (this.fetchMinSize != null) {
                consumerProperties.put("fetch.min.bytes", this.fetchMinSize);
            }
            if (this.heartbeatInterval != null) {
                consumerProperties.put("heartbeat.interval.ms", this.heartbeatInterval);
            }
            if (this.keyDeserializer != null) {
                consumerProperties.put("key.deserializer", this.keyDeserializer);
            }
            KafkaProperties.addSslProperties(consumerProperties, this.ssl);
            if (messageConverterMode == MessageConverterMode.CLOUD_EVENT) {
                consumerProperties.put("value.deserializer", CloudEventDeserializer.class);
            } else if (this.valueDeserializer != null) {
                consumerProperties.put("value.deserializer", this.valueDeserializer);
            }
            if (this.maxPollRecords != null) {
                consumerProperties.put("max.poll.records", this.maxPollRecords);
            }
            if (!CollectionUtils.isEmpty(this.properties)) {
                consumerProperties.putAll(this.properties);
            }
            return consumerProperties;
        }
    }

    public static class Fetcher {
        private boolean enabled = true;
        private long pollTimeout = 5000L;
        private int bufferSize = 10000;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getPollTimeout() {
            return this.pollTimeout;
        }

        public void setPollTimeout(long pollTimeout) {
            this.pollTimeout = pollTimeout;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }
    }

    public static class Producer {
        private final Ssl ssl = new Ssl();
        private String acks;
        private Integer batchSize;
        private List<String> bootstrapServers;
        private Long bufferMemory;
        private String clientId;
        private String compressionType;
        private String transactionIdPrefix;
        private Class<?> keySerializer = StringSerializer.class;
        private Class<?> valueSerializer = ByteArraySerializer.class;
        private Integer retries;
        private final Map<String, String> properties = new HashMap<String, String>();
        private EventProcessorMode eventProcessorMode = EventProcessorMode.SUBSCRIBING;

        public Ssl getSsl() {
            return this.ssl;
        }

        public String getAcks() {
            return this.acks;
        }

        public void setAcks(String acks) {
            this.acks = acks;
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public Long getBufferMemory() {
            return this.bufferMemory;
        }

        public void setBufferMemory(Long bufferMemory) {
            this.bufferMemory = bufferMemory;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getCompressionType() {
            return this.compressionType;
        }

        public void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public String getTransactionIdPrefix() {
            return this.transactionIdPrefix;
        }

        public void setTransactionIdPrefix(String transactionIdPrefix) {
            this.transactionIdPrefix = transactionIdPrefix;
        }

        public Class<?> getKeySerializer() {
            return this.keySerializer;
        }

        public void setKeySerializer(Class<?> keySerializer) {
            this.keySerializer = keySerializer;
        }

        public Class<?> getValueSerializer() {
            return this.valueSerializer;
        }

        public void setValueSerializer(Class<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public EventProcessorMode getEventProcessorMode() {
            return this.eventProcessorMode;
        }

        public void setEventProcessorMode(EventProcessorMode eventProcessorMode) {
            this.eventProcessorMode = eventProcessorMode;
        }

        public Map<String, Object> buildProperties(MessageConverterMode messageConverterMode) {
            HashMap<String, Object> producerProperties = new HashMap<String, Object>();
            if (this.acks != null) {
                producerProperties.put("acks", this.acks);
            }
            if (this.batchSize != null) {
                producerProperties.put("batch.size", this.batchSize);
            }
            if (this.bootstrapServers != null) {
                producerProperties.put("bootstrap.servers", this.bootstrapServers);
            }
            if (this.bufferMemory != null) {
                producerProperties.put("buffer.memory", this.bufferMemory);
            }
            if (this.clientId != null) {
                producerProperties.put("client.id", this.clientId);
            }
            if (this.compressionType != null) {
                producerProperties.put("compression.type", this.compressionType);
            }
            if (this.keySerializer != null) {
                producerProperties.put("key.serializer", this.keySerializer);
            }
            if (this.retries != null) {
                producerProperties.put("retries", this.retries);
            }
            KafkaProperties.addSslProperties(producerProperties, this.ssl);
            if (messageConverterMode == MessageConverterMode.CLOUD_EVENT) {
                producerProperties.put("value.serializer", CloudEventSerializer.class);
            } else if (this.valueSerializer != null) {
                producerProperties.put("value.serializer", this.valueSerializer);
            }
            if (!CollectionUtils.isEmpty(this.properties)) {
                producerProperties.putAll(this.properties);
            }
            return producerProperties;
        }
    }

    public static class Publisher {
        private boolean enabled = true;
        private ConfirmationMode confirmationMode = ConfirmationMode.NONE;
        private String processingGroup = "__axon-kafka-event-publishing-group";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public ConfirmationMode getConfirmationMode() {
            return this.confirmationMode;
        }

        public void setConfirmationMode(ConfirmationMode confirmationMode) {
            this.confirmationMode = confirmationMode;
        }

        public String getProcessingGroup() {
            return this.processingGroup;
        }

        public void setProcessingGroup(String processingGroup) {
            this.processingGroup = processingGroup;
        }
    }
}

