/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer;

import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicSubscriber;

public class TopicPatternSubscriber
implements TopicSubscriber {
    private final Pattern pattern;

    public TopicPatternSubscriber(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public void subscribeTopics(Consumer consumer) {
        consumer.subscribe(this.pattern);
    }

    @Override
    public boolean subscribesToTopicName(String topic) {
        return this.pattern.matcher(topic).matches();
    }

    @Override
    public String describe() {
        return "pattern=[" + this.pattern + "]";
    }
}

