/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicListSubscriber;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicPatternSubscriber;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicSubscriber;

public abstract class TopicSubscriberBuilder<T extends TopicSubscriberBuilder<T>> {
    protected TopicSubscriber subscriber = new TopicListSubscriber(Collections.singletonList("Axon.Events"));

    protected abstract T self();

    public TopicSubscriber getSubscriber() {
        return this.subscriber;
    }

    public T topics(List<String> topics) {
        BuilderUtils.assertThat(topics, topicList -> Objects.nonNull(topicList) && !topicList.isEmpty(), (String)"The topics may not be null or empty");
        this.subscriber = new TopicListSubscriber(topics);
        return this.self();
    }

    public T addTopic(String topic) {
        BuilderUtils.assertThat((Object)topic, name -> Objects.nonNull(name) && !"".equals(name), (String)"The topic may not be null or empty");
        if (!this.isListBasedSubscription()) {
            throw new IllegalStateException("Cannot add topic to a pattern subscriber");
        }
        ((TopicListSubscriber)this.subscriber).addTopic(topic);
        return this.self();
    }

    public T topicPattern(Pattern pattern) {
        BuilderUtils.assertNonNull((Object)pattern, (String)"The pattern may not be null");
        this.subscriber = new TopicPatternSubscriber(pattern);
        return this.self();
    }

    private boolean isListBasedSubscription() {
        return this.subscriber instanceof TopicListSubscriber;
    }
}

