/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer.streamable;

import java.util.Comparator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.KafkaRecordMetaData;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.KafkaTrackingToken;

public class KafkaEventMessage
implements KafkaRecordMetaData<TrackedEventMessage<?>>,
Comparable<KafkaEventMessage> {
    private static final Comparator<KafkaEventMessage> MESSAGE_COMPARATOR = Comparator.comparing(KafkaEventMessage::timestamp).thenComparing(KafkaEventMessage::partition).thenComparing(KafkaEventMessage::offset);
    private final TrackedEventMessage<?> eventMessage;
    private final int partition;
    private final long offset;
    private final long timestamp;

    public KafkaEventMessage(TrackedEventMessage<?> eventMessage, int partition, long offset, long timestamp) {
        Assert.notNull(eventMessage, () -> "Event Message may not be null");
        this.eventMessage = eventMessage;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
    }

    public static KafkaEventMessage from(EventMessage<?> eventMessage, ConsumerRecord<?, ?> consumerRecord, KafkaTrackingToken trackingToken) {
        return new KafkaEventMessage(EventUtils.asTrackedEventMessage(eventMessage, (TrackingToken)trackingToken), consumerRecord.partition(), consumerRecord.offset(), consumerRecord.timestamp());
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public TrackedEventMessage<?> value() {
        return this.eventMessage;
    }

    @Override
    public int compareTo(KafkaEventMessage other) {
        return MESSAGE_COMPARATOR.compare(this, other);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KafkaEventMessage) {
            KafkaEventMessage otherMessage = (KafkaEventMessage)other;
            return this.timestamp == otherMessage.timestamp && this.partition == otherMessage.partition && this.offset == otherMessage.offset;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = (int)((long)(31 * hash) + this.timestamp);
        hash = 31 * hash + this.partition;
        hash = (int)((long)(31 * hash) + this.offset);
        return hash;
    }

    public String toString() {
        return "KafkaEventMessage{eventMessage=" + this.eventMessage + ", partition=" + this.partition + ", offset=" + this.offset + ", timestamp=" + this.timestamp + '}';
    }
}

