/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer.streamable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongBinaryOperator;
import org.apache.kafka.common.TopicPartition;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.TopicPartitionDeserializer;

public class KafkaTrackingToken
implements TrackingToken,
Serializable {
    @JsonDeserialize(keyUsing=TopicPartitionDeserializer.class)
    private final Map<TopicPartition, Long> positions;
    private static final String INCOMPATIBLE_TOKEN_MESSAGE = "Incompatible token type provided.";

    private KafkaTrackingToken(Map<TopicPartition, Long> positions) {
        this.positions = Collections.unmodifiableMap(new HashMap<TopicPartition, Long>(positions));
    }

    @JsonCreator
    public static KafkaTrackingToken newInstance(@JsonProperty(value="positions") Map<TopicPartition, Long> positions) {
        return new KafkaTrackingToken(positions);
    }

    public static KafkaTrackingToken emptyToken() {
        return KafkaTrackingToken.newInstance(new HashMap<TopicPartition, Long>());
    }

    public static boolean isNotEmpty(KafkaTrackingToken token) {
        return !KafkaTrackingToken.isEmpty(token);
    }

    public static boolean isEmpty(KafkaTrackingToken token) {
        return token == null || token.positions.isEmpty();
    }

    public static KafkaTrackingToken from(TrackingToken trackingToken) {
        Assert.isTrue((trackingToken == null || trackingToken instanceof KafkaTrackingToken ? 1 : 0) != 0, () -> INCOMPATIBLE_TOKEN_MESSAGE);
        return trackingToken == null ? KafkaTrackingToken.emptyToken() : (KafkaTrackingToken)trackingToken;
    }

    public Map<TopicPartition, Long> getPositions() {
        return this.positions;
    }

    public KafkaTrackingToken advancedTo(String topic, int partition, long offset) {
        Assert.isTrue((topic != null && !topic.equals("") ? 1 : 0) != 0, () -> "Topic should be a non-empty string");
        Assert.isTrue((partition >= 0 ? 1 : 0) != 0, () -> "Partition may not be negative");
        Assert.isTrue((offset >= 0L ? 1 : 0) != 0, () -> "Offset may not be negative");
        return this.advancedTo(new TopicPartition(topic, partition), offset);
    }

    private KafkaTrackingToken advancedTo(TopicPartition topicPartition, long offset) {
        HashMap<TopicPartition, Long> updatedPositions = new HashMap<TopicPartition, Long>(this.getPositions());
        updatedPositions.put(topicPartition, offset);
        return new KafkaTrackingToken(updatedPositions);
    }

    public TrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof KafkaTrackingToken), () -> INCOMPATIBLE_TOKEN_MESSAGE);
        return new KafkaTrackingToken(this.bounds((KafkaTrackingToken)other, Math::min));
    }

    public TrackingToken upperBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof KafkaTrackingToken), () -> INCOMPATIBLE_TOKEN_MESSAGE);
        return new KafkaTrackingToken(this.bounds((KafkaTrackingToken)other, Math::max));
    }

    private Map<TopicPartition, Long> bounds(KafkaTrackingToken other, LongBinaryOperator boundsFunction) {
        HashMap<TopicPartition, Long> intersection = new HashMap<TopicPartition, Long>(this.getPositions());
        other.getPositions().forEach(intersection::putIfAbsent);
        intersection.keySet().forEach(topicPartition -> intersection.put((TopicPartition)topicPartition, boundsFunction.applyAsLong(this.getPositions().getOrDefault(topicPartition, 0L), other.getPositions().getOrDefault(topicPartition, 0L))));
        return intersection;
    }

    public boolean covers(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof KafkaTrackingToken), () -> INCOMPATIBLE_TOKEN_MESSAGE);
        KafkaTrackingToken otherToken = (KafkaTrackingToken)other;
        return otherToken.getPositions().entrySet().stream().allMatch(offsetsEntry -> this.match((TopicPartition)offsetsEntry.getKey(), (Long)offsetsEntry.getValue()));
    }

    private boolean match(TopicPartition otherTopicPartition, long otherOffset) {
        return otherOffset <= this.getPositions().getOrDefault(otherTopicPartition, -1L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTrackingToken that = (KafkaTrackingToken)o;
        return Objects.equals(this.positions, that.positions);
    }

    public int hashCode() {
        return Objects.hash(this.positions);
    }

    public String toString() {
        return "KafkaTrackingToken{positions=" + this.positions + '}';
    }
}

