/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.tokenstore;

import java.time.Instant;
import java.util.UUID;
import org.apache.kafka.common.header.Headers;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventhandling.tokenstore.GenericTokenEntry;
import org.axonframework.extensions.kafka.eventhandling.HeaderUtils;

class TokenUpdate {
    private final UUID id;
    private final String processorName;
    private final int segment;
    private final String owner;
    private final byte[] token;
    private final String tokenType;
    private final Instant timestamp;
    private final long sequenceNumber;
    private static final String ID_HEADER = "id";
    private static final String PROCESSOR_NAME_HEADER = "processorName";
    private static final String SEGMENT_HEADER = "segment";
    private static final String OWNER_HEADER = "owner";
    private static final String TOKEN_TYPE_HEADER = "tokenType";
    private static final String TIMESTAMP_HEADER = "timestamp";
    private static final String SEQUENCE_NUMBER_HEADER = "sequenceNumber";

    TokenUpdate(AbstractTokenEntry<byte[]> tokenEntry, long sequenceNumber) {
        this.id = UUID.randomUUID();
        this.processorName = tokenEntry.getProcessorName();
        this.segment = tokenEntry.getSegment();
        this.owner = tokenEntry.getOwner();
        this.token = tokenEntry.getSerializedToken() == null ? new byte[]{} : (byte[])tokenEntry.getSerializedToken().getData();
        this.tokenType = tokenEntry.getSerializedToken() == null ? null : tokenEntry.getSerializedToken().getType().getName();
        this.timestamp = tokenEntry.timestamp();
        this.sequenceNumber = sequenceNumber;
    }

    TokenUpdate(Headers headers, byte[] data) {
        this.id = UUID.fromString(HeaderUtils.valueAsString(headers, ID_HEADER));
        this.processorName = HeaderUtils.valueAsString(headers, PROCESSOR_NAME_HEADER);
        this.segment = HeaderUtils.valueAsInt(headers, SEGMENT_HEADER, 0);
        this.owner = HeaderUtils.valueAsString(headers, OWNER_HEADER);
        this.token = data;
        this.tokenType = HeaderUtils.valueAsString(headers, TOKEN_TYPE_HEADER);
        this.timestamp = Instant.ofEpochMilli(HeaderUtils.valueAsLong(headers, TIMESTAMP_HEADER));
        this.sequenceNumber = HeaderUtils.valueAsLong(headers, SEQUENCE_NUMBER_HEADER, 0L);
    }

    TokenUpdate(TokenUpdate update, boolean delete) {
        this.id = UUID.randomUUID();
        this.processorName = update.processorName;
        this.segment = update.segment;
        this.owner = delete ? null : update.owner;
        this.token = delete ? null : update.token;
        this.tokenType = delete ? null : update.tokenType;
        this.timestamp = AbstractTokenEntry.clock.instant();
        this.sequenceNumber = update.sequenceNumber + 1L;
    }

    void setHeaders(Headers headers) {
        HeaderUtils.addHeader(headers, ID_HEADER, this.id);
        HeaderUtils.addHeader(headers, PROCESSOR_NAME_HEADER, this.processorName);
        HeaderUtils.addHeader(headers, SEGMENT_HEADER, this.segment);
        HeaderUtils.addHeader(headers, OWNER_HEADER, this.owner);
        HeaderUtils.addHeader(headers, TOKEN_TYPE_HEADER, this.tokenType);
        HeaderUtils.addHeader(headers, TIMESTAMP_HEADER, this.timestamp);
        HeaderUtils.addHeader(headers, SEQUENCE_NUMBER_HEADER, this.sequenceNumber);
    }

    AbstractTokenEntry<byte[]> toTokenEntry() {
        return new GenericTokenEntry((Object)(this.token.length == 0 ? null : this.token), this.tokenType, this.timestamp.toString(), this.owner, this.processorName, this.segment, byte[].class);
    }

    UUID getId() {
        return this.id;
    }

    String getProcessorName() {
        return this.processorName;
    }

    int getSegment() {
        return this.segment;
    }

    String getOwner() {
        return this.owner;
    }

    byte[] getToken() {
        return this.token;
    }

    Instant getTimestamp() {
        return this.timestamp;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

