/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.deadletter;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterEventEntry;
import org.axonframework.extensions.mongo.eventhandling.deadletter.InstantEntry;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.Serializer;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DeadLetterEntry {
    private static final int ORDER_ASC = 1;
    private static final String PROCESSING_GROUP_KEY = "processingGroup";
    private static final String SEQUENCE_IDENTIFIER_KEY = "sequenceIdentifier";
    private static final String INDEX_KEY = "index";
    private static final String MESSAGE_KEY = "message";
    private static final String ENQUEUED_AT_KEY = "enqueuedAt";
    private static final String LAST_TOUCHED_KEY = "lastTouched";
    private static final String LAST_TOUCHED_SECONDS_KEY = "lastTouched.seconds";
    private static final String LAST_TOUCHED_NANOSECONDS_KEY = "lastTouched.nanoseconds";
    private static final String PROCESSING_STARTED_KEY = "processingStarted";
    private static final String PROCESSING_STARTED_SECONDS_KEY = "processingStarted.seconds";
    private static final String PROCESSING_STARTED_NANOSECONDS_KEY = "processingStarted.nanoseconds";
    private static final String CAUSE_TYPE_KEY = "causeType";
    private static final String CAUSE_MESSAGE_KEY = "causeMessage";
    private static final String DIAGNOSTICS_KEY = "diagnostics";
    private final String processingGroup;
    private final String sequenceIdentifier;
    private final long index;
    private final Document message;
    private final Document enqueuedAt;
    private Document lastTouched;
    private Document processingStarted;
    private String causeType;
    private String causeMessage;
    private Object serializedDiagnostics;

    public DeadLetterEntry(Document dbDeadLetterEntry) {
        this.processingGroup = dbDeadLetterEntry.getString((Object)PROCESSING_GROUP_KEY);
        this.sequenceIdentifier = dbDeadLetterEntry.getString((Object)SEQUENCE_IDENTIFIER_KEY);
        this.index = dbDeadLetterEntry.getLong((Object)INDEX_KEY);
        this.message = (Document)dbDeadLetterEntry.get((Object)MESSAGE_KEY);
        this.enqueuedAt = (Document)dbDeadLetterEntry.get((Object)ENQUEUED_AT_KEY);
        this.lastTouched = (Document)dbDeadLetterEntry.get((Object)LAST_TOUCHED_KEY);
        this.processingStarted = (Document)dbDeadLetterEntry.get((Object)PROCESSING_STARTED_KEY);
        this.causeType = dbDeadLetterEntry.getString((Object)CAUSE_TYPE_KEY);
        this.causeMessage = dbDeadLetterEntry.getString((Object)CAUSE_MESSAGE_KEY);
        this.serializedDiagnostics = dbDeadLetterEntry.get((Object)DIAGNOSTICS_KEY);
    }

    public DeadLetterEntry(String processingGroup, String sequenceIdentifier, long index, Document message, Instant enqueuedAt, Instant lastTouched, Cause cause, MetaData diagnostics, Serializer serializer) {
        this.processingGroup = processingGroup;
        this.sequenceIdentifier = sequenceIdentifier;
        this.index = index;
        this.message = message;
        this.enqueuedAt = new InstantEntry(enqueuedAt).asDocument();
        this.lastTouched = new InstantEntry(lastTouched).asDocument();
        Optional.ofNullable(cause).ifPresent(c -> {
            this.causeType = c.type();
            this.causeMessage = c.message();
        });
        Class<String> serializationTarget = String.class;
        if (serializer.canSerializeTo(DBObject.class)) {
            serializationTarget = DBObject.class;
        }
        this.serializedDiagnostics = serializer.serialize((Object)diagnostics, serializationTarget).getData();
    }

    public Document asDocument() {
        return new Document().append(PROCESSING_GROUP_KEY, (Object)this.processingGroup).append(SEQUENCE_IDENTIFIER_KEY, (Object)this.sequenceIdentifier).append(INDEX_KEY, (Object)this.index).append(MESSAGE_KEY, (Object)this.message).append(ENQUEUED_AT_KEY, (Object)this.enqueuedAt).append(LAST_TOUCHED_KEY, (Object)this.lastTouched).append(PROCESSING_STARTED_KEY, (Object)this.processingStarted).append(CAUSE_TYPE_KEY, (Object)this.causeType).append(CAUSE_MESSAGE_KEY, (Object)this.causeMessage).append(DIAGNOSTICS_KEY, this.serializedDiagnostics);
    }

    public String getProcessingGroup() {
        return this.processingGroup;
    }

    public String getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public long getIndex() {
        return this.index;
    }

    public DeadLetterEventEntry getMessage(@Nonnull EventEntryConfiguration configuration) {
        return new DeadLetterEventEntry(this.message, configuration);
    }

    public Instant getEnqueuedAt() {
        return new InstantEntry(this.enqueuedAt).getInstant();
    }

    public Instant getLastTouched() {
        return new InstantEntry(this.lastTouched).getInstant();
    }

    public void setLastTouched(@Nonnull Instant lastTouched) {
        this.lastTouched = new InstantEntry(lastTouched).asDocument();
    }

    public Instant getProcessingStarted() {
        return Optional.ofNullable(this.processingStarted).map(InstantEntry::new).map(InstantEntry::getInstant).orElse(null);
    }

    public void setCause(@Nonnull Cause cause) {
        this.causeType = cause.type();
        this.causeMessage = cause.message();
    }

    public String getCauseType() {
        return this.causeType;
    }

    public String getCauseMessage() {
        return this.causeMessage;
    }

    public SerializedMetaData<?> getDiagnostics() {
        return new SerializedMetaData(this.serializedDiagnostics, this.getRepresentationType());
    }

    public void setDiagnostics(@Nonnull MetaData diagnostics, @Nonnull Serializer serializer) {
        Class<String> serializationTarget = String.class;
        if (serializer.canSerializeTo(DBObject.class)) {
            serializationTarget = DBObject.class;
        }
        this.serializedDiagnostics = serializer.serialize((Object)diagnostics, serializationTarget).getData();
    }

    public void clearProcessingStarted() {
        this.processingStarted = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeadLetterEntry that = (DeadLetterEntry)o;
        return Objects.equals(this.processingGroup, that.processingGroup) && Objects.equals(this.sequenceIdentifier, that.sequenceIdentifier) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.processingGroup, this.sequenceIdentifier, this.index);
    }

    public String toString() {
        return "DeadLetterEntry{processingGroup='" + this.processingGroup + '\'' + ", sequenceIdentifier='" + this.sequenceIdentifier + '\'' + ", index=" + this.index + ", message=" + this.message + ", enqueuedAt=" + this.enqueuedAt + ", lastTouched=" + this.lastTouched + ", processingStarted=" + this.processingStarted + ", causeType='" + this.causeType + '\'' + ", causeMessage='" + this.causeMessage + '\'' + ", diagnostics=" + this.serializedDiagnostics + '}';
    }

    public static void ensureDeadLetterIndexes(@Nonnull MongoCollection<Document> deadLetterCollection) {
        deadLetterCollection.createIndex((Bson)new BasicDBObject(PROCESSING_GROUP_KEY, (Object)1), new IndexOptions().unique(false).name("processingGroupIdentifierIndex"));
        deadLetterCollection.createIndex((Bson)new BasicDBObject(PROCESSING_GROUP_KEY, (Object)1).append(SEQUENCE_IDENTIFIER_KEY, (Object)1), new IndexOptions().unique(false).name("processingGroupAndSequenceIdentifierIndex"));
        deadLetterCollection.createIndex((Bson)new BasicDBObject(PROCESSING_GROUP_KEY, (Object)1).append(SEQUENCE_IDENTIFIER_KEY, (Object)1).append(INDEX_KEY, (Object)1), new IndexOptions().unique(true).name("uniqueDeadLetterEntryIndex"));
    }

    public static Bson processingGroupFilter(@Nonnull String processingGroup) {
        return Filters.eq((String)PROCESSING_GROUP_KEY, (Object)processingGroup);
    }

    public static Bson processingGroupAndSequenceIdentifierFilter(@Nonnull String processingGroup, @Nonnull String sequenceIdentifier) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)PROCESSING_GROUP_KEY, (Object)processingGroup), Filters.eq((String)SEQUENCE_IDENTIFIER_KEY, (Object)sequenceIdentifier)});
    }

    public static Bson findOneFilter(@Nonnull String processingGroup, @Nonnull String sequenceIdentifier, long index) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)PROCESSING_GROUP_KEY, (Object)processingGroup), Filters.eq((String)SEQUENCE_IDENTIFIER_KEY, (Object)sequenceIdentifier), Filters.eq((String)INDEX_KEY, (Object)index)});
    }

    public static Bson nextItemInSequenceFilter(@Nonnull String processingGroup, @Nonnull String sequenceIdentifier, long index) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)PROCESSING_GROUP_KEY, (Object)processingGroup), Filters.eq((String)SEQUENCE_IDENTIFIER_KEY, (Object)sequenceIdentifier), Filters.gt((String)INDEX_KEY, (Object)index)});
    }

    public static Bson uniqueNotLockedFilter(@Nonnull String processingGroup, @Nonnull String sequenceIdentifier, long index, @Nonnull Instant processingStartedLimit) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)PROCESSING_GROUP_KEY, (Object)processingGroup), Filters.eq((String)SEQUENCE_IDENTIFIER_KEY, (Object)sequenceIdentifier), Filters.eq((String)INDEX_KEY, (Object)index), Filters.or((Bson[])new Bson[]{Filters.exists((String)PROCESSING_STARTED_SECONDS_KEY, (boolean)false), Filters.lt((String)PROCESSING_STARTED_SECONDS_KEY, (Object)processingStartedLimit.getEpochSecond()), Filters.and((Bson[])new Bson[]{Filters.eq((String)PROCESSING_STARTED_SECONDS_KEY, (Object)processingStartedLimit.getEpochSecond()), Filters.lt((String)PROCESSING_STARTED_NANOSECONDS_KEY, (Object)processingStartedLimit.getNano())})})});
    }

    public static List<? extends Bson> firstNotLockedFilter(@Nonnull String processingGroup, @Nonnull Instant processingStartedLimit) {
        Document result = new Document().append(LAST_TOUCHED_KEY, (Object)"$lastTouched").append(PROCESSING_STARTED_KEY, (Object)"$processingStarted").append("_id", (Object)"$_id");
        return Arrays.asList(Aggregates.match((Bson)Filters.eq((String)PROCESSING_GROUP_KEY, (Object)processingGroup)), Aggregates.group((Object)"$sequenceIdentifier", (BsonField[])new BsonField[]{Accumulators.first((String)INDEX_KEY, (Object)result)}), Aggregates.replaceRoot((Object)"$index"), Aggregates.match((Bson)Filters.or((Bson[])new Bson[]{Filters.exists((String)PROCESSING_STARTED_SECONDS_KEY, (boolean)false), Filters.lt((String)PROCESSING_STARTED_SECONDS_KEY, (Object)processingStartedLimit.getEpochSecond()), Filters.and((Bson[])new Bson[]{Filters.eq((String)PROCESSING_STARTED_SECONDS_KEY, (Object)processingStartedLimit.getEpochSecond()), Filters.lt((String)PROCESSING_STARTED_NANOSECONDS_KEY, (Object)processingStartedLimit.getNano())})})), Aggregates.sort((Bson)Sorts.ascending((String[])new String[]{LAST_TOUCHED_SECONDS_KEY, LAST_TOUCHED_NANOSECONDS_KEY})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"_id"})})));
    }

    public static Bson updateProcessingStarted(@Nonnull Instant now) {
        return Updates.set((String)PROCESSING_STARTED_KEY, (Object)new InstantEntry(now).asDocument());
    }

    public static DistinctIterable<String> sequenceIdentifierIterator(@Nonnull MongoCollection<Document> collection, @Nonnull String processingGroup) {
        return collection.distinct(SEQUENCE_IDENTIFIER_KEY, DeadLetterEntry.processingGroupFilter(processingGroup), String.class);
    }

    public static Bson indexSortDescending() {
        return Sorts.descending((String[])new String[]{INDEX_KEY});
    }

    public static Bson indexSortAscending() {
        return Sorts.ascending((String[])new String[]{INDEX_KEY});
    }

    public static Long index(@Nullable Document document) {
        return Optional.ofNullable(document).map(d -> d.getLong((Object)INDEX_KEY)).orElse(null);
    }

    public static boolean isLocked(@Nonnull Instant processingStartedLimit, @Nonnull Document dbDeadLetterEntry) {
        return Optional.ofNullable((Document)dbDeadLetterEntry.get((Object)PROCESSING_STARTED_KEY)).map(InstantEntry::new).map(InstantEntry::getInstant).map(ps -> ps.isAfter(processingStartedLimit)).orElse(false);
    }

    private Class<?> getRepresentationType() {
        Class<String> representationType = String.class;
        if (this.serializedDiagnostics instanceof DBObject) {
            representationType = DBObject.class;
        } else if (this.serializedDiagnostics instanceof Document) {
            representationType = Document.class;
        }
        return representationType;
    }
}

