/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.deadletter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.EventEntry;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.bson.Document;
import org.bson.types.Binary;

public class DeadLetterEventEntry
extends EventEntry {
    private static final String MESSAGE_TYPE_KEY = "messageType";
    private static final String TOKEN_TYPE_KEY = "tokenType";
    private static final String TOKEN_KEY = "token";
    private String messageType;
    private String tokenType;
    private byte[] token;

    public DeadLetterEventEntry(@Nonnull Document dbObject, @Nonnull EventEntryConfiguration configuration) {
        super(dbObject, configuration);
        this.messageType = dbObject.getString((Object)MESSAGE_TYPE_KEY);
        Optional.ofNullable(dbObject.getString((Object)TOKEN_TYPE_KEY)).ifPresent(type -> {
            this.tokenType = type;
        });
        Optional.ofNullable(dbObject.get((Object)TOKEN_KEY)).ifPresent(t -> {
            this.token = ((Binary)t).getData();
        });
    }

    private DeadLetterEventEntry(@Nonnull DomainEventMessage<?> event, @Nonnull Serializer serializer) {
        super(event, serializer);
    }

    public static DeadLetterEventEntry fromEventMessage(@Nonnull EventMessage<?> message, @Nonnull Serializer serializer) {
        DeadLetterEventEntry entry = new DeadLetterEventEntry(DeadLetterEventEntry.asDomainEventMessage(message), serializer);
        entry.messageType = message.getClass().getName();
        Optional.of(message).filter(TrackedEventMessage.class::isInstance).map(TrackedEventMessage.class::cast).map(m -> serializer.serialize((Object)m.trackingToken(), byte[].class)).ifPresent(t -> {
            entry.tokenType = t.getType().getName();
            entry.token = (byte[])t.getData();
        });
        return entry;
    }

    private static <T> DomainEventMessage<T> asDomainEventMessage(EventMessage<T> eventMessage) {
        if (eventMessage instanceof DomainEventMessage) {
            return (DomainEventMessage)eventMessage;
        }
        return new GenericDomainEventMessage(null, null, 0L, eventMessage, () -> eventMessage.getTimestamp());
    }

    @Override
    public Document asDocument(@Nonnull EventEntryConfiguration configuration) {
        Document document = super.asDocument(configuration);
        document.append(MESSAGE_TYPE_KEY, (Object)this.messageType);
        if (!Objects.isNull(this.tokenType) && !Objects.isNull(this.token)) {
            document.append(TOKEN_TYPE_KEY, (Object)this.tokenType).append(TOKEN_KEY, (Object)this.token);
        }
        return document;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public SimpleSerializedObject<byte[]> getTrackingToken() {
        if (this.token == null) {
            return null;
        }
        return new SimpleSerializedObject((Object)this.token, byte[].class, this.tokenType, null);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DeadLetterEventEntry that = (DeadLetterEventEntry)o;
        if (!Objects.equals(this.messageType, that.messageType)) {
            return false;
        }
        if (!Objects.equals(this.tokenType, that.tokenType)) {
            return false;
        }
        return Arrays.equals(this.token, that.token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.messageType, this.tokenType, Arrays.hashCode(this.token));
    }

    @Override
    public String toString() {
        return "DeadLetterEventEntry{messageType='" + this.messageType + '\'' + ", eventIdentifier='" + this.getEventIdentifier() + '\'' + ", timeStamp='" + this.getTimestamp() + '\'' + ", payload='" + this.getPayload() + '\'' + ", metaData=" + this.getMetaData() + ", type='" + this.getType() + '\'' + ", aggregateIdentifier='" + this.getAggregateIdentifier() + '\'' + ", sequenceNumber=" + this.getSequenceNumber() + ", tokenType='" + this.tokenType + '\'' + ", token=" + Arrays.toString(this.token) + '}';
    }
}

