/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.deadletter;

import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterEventEntry;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterMongoConverter;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.Serializer;

public class EventMessageDeadLetterMongoConverter
implements DeadLetterMongoConverter<EventMessage<?>> {
    @Override
    public DeadLetterEventEntry convert(EventMessage<?> message, Serializer serializer) {
        return DeadLetterEventEntry.fromEventMessage(message, serializer);
    }

    @Override
    public EventMessage<?> convert(DeadLetterEventEntry entry, Serializer serializer) {
        SerializedMessage serializedMessage = new SerializedMessage(entry.getEventIdentifier(), entry.getPayload(), entry.getMetaData(), serializer);
        Supplier<Instant> timestampSupplier = entry::getTimestamp;
        if (entry.getTrackingToken() != null) {
            TrackingToken trackingToken = (TrackingToken)serializer.deserialize(entry.getTrackingToken());
            if (entry.getAggregateIdentifier() != null) {
                return new GenericTrackedDomainEventMessage(trackingToken, entry.getType(), entry.getAggregateIdentifier(), entry.getSequenceNumber(), (Message)serializedMessage, timestampSupplier);
            }
            return new GenericTrackedEventMessage(trackingToken, (Message)serializedMessage, timestampSupplier);
        }
        if (entry.getAggregateIdentifier() != null) {
            return new GenericDomainEventMessage(entry.getType(), entry.getAggregateIdentifier(), entry.getSequenceNumber(), serializedMessage.getPayload(), (Map)serializedMessage.getMetaData(), serializedMessage.getIdentifier(), timestampSupplier.get());
        }
        return new GenericEventMessage((Message)serializedMessage, timestampSupplier);
    }

    @Override
    public boolean canConvert(DeadLetterEventEntry message) {
        return message.getMessageType().equals(GenericTrackedDomainEventMessage.class.getName()) || message.getMessageType().equals(GenericEventMessage.class.getName()) || message.getMessageType().equals(GenericDomainEventMessage.class.getName()) || message.getMessageType().equals(GenericTrackedEventMessage.class.getName());
    }

    @Override
    public boolean canConvert(EventMessage<?> message) {
        return message instanceof GenericEventMessage;
    }
}

