/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.deadletter;

import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.extensions.mongo.eventhandling.deadletter.NotAnInstantDocumentException;
import org.bson.Document;

public class InstantEntry {
    static final String SECONDS_KEY = "seconds";
    static final String NANOSECONDS_KEY = "nanoseconds";
    static final Set<String> KEY_SET = Stream.of("seconds", "nanoseconds").collect(Collectors.toCollection(HashSet::new));
    private final Instant instant;

    public Instant getInstant() {
        return this.instant;
    }

    public InstantEntry(@Nonnull Document dbInstantEntry) {
        Set entryKeys = dbInstantEntry.keySet();
        if (!entryKeys.equals(KEY_SET)) {
            throw new NotAnInstantDocumentException(String.format("Actual keys on the document are %s and not %s.", entryKeys, KEY_SET));
        }
        long seconds = dbInstantEntry.getLong((Object)SECONDS_KEY);
        int nanoseconds = dbInstantEntry.getInteger((Object)NANOSECONDS_KEY);
        this.instant = Instant.ofEpochSecond(seconds, nanoseconds);
    }

    public InstantEntry(Instant instant) {
        this.instant = instant;
    }

    public Document asDocument() {
        return new Document().append(SECONDS_KEY, (Object)this.instant.getEpochSecond()).append(NANOSECONDS_KEY, (Object)this.instant.getNano());
    }
}

