/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.deadletter;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterEntry;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.ThrowableCause;

public class MongoDeadLetter<M extends EventMessage<?>>
implements DeadLetter<M> {
    private final long index;
    private final String sequenceIdentifier;
    private final Instant enqueuedAt;
    private final Instant lastTouched;
    private final Cause cause;
    private final MetaData diagnostics;
    private final M message;

    public MongoDeadLetter(DeadLetterEntry entry, MetaData diagnostics, M message) {
        this.index = entry.getIndex();
        this.enqueuedAt = entry.getEnqueuedAt();
        this.lastTouched = entry.getLastTouched();
        this.sequenceIdentifier = entry.getSequenceIdentifier();
        this.cause = entry.getCauseType() != null ? new ThrowableCause(entry.getCauseType(), entry.getCauseMessage()) : null;
        this.diagnostics = diagnostics;
        this.message = message;
    }

    MongoDeadLetter(Long index, String sequenceIdentifier, Instant enqueuedAt, Instant lastTouched, Cause cause, MetaData diagnostics, M message) {
        this.index = index;
        this.sequenceIdentifier = sequenceIdentifier;
        this.enqueuedAt = enqueuedAt;
        this.lastTouched = lastTouched;
        this.cause = cause;
        this.diagnostics = diagnostics;
        this.message = message;
    }

    public long index() {
        return this.index;
    }

    public String sequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public M message() {
        return this.message;
    }

    public Optional<Cause> cause() {
        return Optional.ofNullable(this.cause);
    }

    public Instant enqueuedAt() {
        return this.enqueuedAt;
    }

    public Instant lastTouched() {
        return this.lastTouched;
    }

    public MetaData diagnostics() {
        return this.diagnostics;
    }

    public DeadLetter<M> markTouched() {
        return new MongoDeadLetter<M>(this.index, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), this.cause, this.diagnostics, this.message);
    }

    public DeadLetter<M> withCause(Throwable requeueCause) {
        return new MongoDeadLetter<M>(this.index, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), (Cause)(requeueCause != null ? new ThrowableCause(requeueCause) : this.cause), this.diagnostics, this.message);
    }

    public DeadLetter<M> withDiagnostics(MetaData diagnostics) {
        return new MongoDeadLetter<M>(this.index, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), this.cause, diagnostics, this.message);
    }

    public String toString() {
        return "JpaDeadLetter{, index=" + this.index + ", sequenceIdentifier='" + this.sequenceIdentifier + "', enqueuedAt=" + this.enqueuedAt + ", lastTouched=" + this.lastTouched + ", cause=" + this.cause + ", diagnostics=" + this.diagnostics + ", message=" + this.message + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDeadLetter that = (MongoDeadLetter)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.sequenceIdentifier.equals(that.sequenceIdentifier)) {
            return false;
        }
        if (!this.enqueuedAt.equals(that.enqueuedAt)) {
            return false;
        }
        if (!this.lastTouched.equals(that.lastTouched)) {
            return false;
        }
        if (!Objects.equals(this.cause, that.cause)) {
            return false;
        }
        if (!Objects.equals(this.diagnostics, that.diagnostics)) {
            return false;
        }
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.sequenceIdentifier, this.enqueuedAt, this.lastTouched, this.cause, this.diagnostics, this.message);
    }
}

