/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.eventstore;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoBulkWriteException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.MongoTrackingToken;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.StorageStrategy;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.DocumentPerEventStorageStrategy;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;

public class MongoEventStorageEngine
extends BatchingEventStorageEngine {
    private final MongoTemplate template;
    private final StorageStrategy storageStrategy;

    protected MongoEventStorageEngine(Builder builder) {
        super((BatchingEventStorageEngine.Builder)builder);
        this.template = builder.template;
        this.storageStrategy = builder.storageStrategy;
        this.ensureIndexes();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static boolean isDuplicateKeyException(Exception exception) {
        return exception instanceof DuplicateKeyException || exception instanceof MongoBulkWriteException && ((MongoBulkWriteException)exception).getWriteErrors().stream().anyMatch(e -> e.getCode() == 11000);
    }

    @Deprecated
    public void ensureIndexes() {
        this.storageStrategy.ensureIndexes(this.template.eventCollection(), this.template.snapshotCollection());
    }

    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (!events.isEmpty()) {
            try {
                this.storageStrategy.appendEvents(this.template.eventCollection(), events, serializer);
            }
            catch (Exception e) {
                this.handlePersistenceException(e, events.get(0));
            }
        }
    }

    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        try {
            this.storageStrategy.appendSnapshot(this.template.snapshotCollection(), snapshot, serializer);
            this.storageStrategy.deleteSnapshots(this.template.snapshotCollection(), snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber());
        }
        catch (Exception e) {
            this.handlePersistenceException(e, (EventMessage)snapshot);
        }
    }

    protected Stream<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return this.storageStrategy.findSnapshots(this.template.snapshotCollection(), aggregateIdentifier);
    }

    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return this.storageStrategy.findDomainEvents(this.template.eventCollection(), aggregateIdentifier, firstSequenceNumber, batchSize);
    }

    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        return this.storageStrategy.findTrackedEvents(this.template.eventCollection(), lastToken, batchSize);
    }

    public Optional<Long> lastSequenceNumberFor(@Nonnull String aggregateIdentifier) {
        return this.storageStrategy.lastSequenceNumberFor(this.template.eventCollection(), aggregateIdentifier);
    }

    public TrackingToken createTailToken() {
        return this.storageStrategy.createTailToken(this.template.eventCollection());
    }

    public TrackingToken createHeadToken() {
        return this.createTokenAt(Instant.now());
    }

    public TrackingToken createTokenAt(@Nonnull Instant dateTime) {
        return MongoTrackingToken.of(dateTime, Collections.emptyMap());
    }

    public static class Builder
    extends BatchingEventStorageEngine.Builder {
        private MongoTemplate template;
        private StorageStrategy storageStrategy = new DocumentPerEventStorageStrategy();

        private Builder() {
            this.persistenceExceptionResolver(x$0 -> MongoEventStorageEngine.isDuplicateKeyException(x$0));
        }

        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            super.snapshotSerializer(snapshotSerializer);
            return this;
        }

        public Builder upcasterChain(EventUpcaster upcasterChain) {
            super.upcasterChain(upcasterChain);
            return this;
        }

        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            super.persistenceExceptionResolver(persistenceExceptionResolver);
            return this;
        }

        public Builder eventSerializer(Serializer eventSerializer) {
            super.eventSerializer(eventSerializer);
            return this;
        }

        @Deprecated
        public Builder snapshotFilter(Predicate<? super DomainEventData<?>> snapshotFilter) {
            super.snapshotFilter(snapshotFilter);
            return this;
        }

        public Builder snapshotFilter(SnapshotFilter snapshotFilter) {
            super.snapshotFilter(snapshotFilter);
            return this;
        }

        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        public Builder mongoTemplate(MongoTemplate template) {
            BuilderUtils.assertNonNull((Object)template, (String)"MongoTemplate may not be null");
            this.template = template;
            return this;
        }

        public Builder storageStrategy(StorageStrategy storageStrategy) {
            BuilderUtils.assertNonNull((Object)storageStrategy, (String)"StorageStrategy may not be null");
            this.storageStrategy = storageStrategy;
            return this;
        }

        public MongoEventStorageEngine build() {
            return new MongoEventStorageEngine(this);
        }

        protected void validate() throws AxonConfigurationException {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.template, (String)"The MongoTemplate is a hard requirement and should be provided");
        }
    }
}

