/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Objects;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.mongo.AbstractMongoTemplate;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.bson.Document;

public class DefaultMongoTemplate
extends AbstractMongoTemplate
implements MongoTemplate {
    private final String domainEventsCollectionName;
    private final String snapshotEventsCollectionName;
    private final String trackingTokensCollectionName;
    private final String sagasCollectionName;
    private final String deadLetterCollectionName;

    protected DefaultMongoTemplate(Builder builder) {
        super(builder);
        this.domainEventsCollectionName = builder.domainEventsCollectionName;
        this.snapshotEventsCollectionName = builder.snapshotEventsCollectionName;
        this.sagasCollectionName = builder.sagasCollectionName;
        this.trackingTokensCollectionName = builder.trackingTokensCollectionName;
        this.deadLetterCollectionName = builder.deadLetterCollectionName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DefaultMongoTemplate withSnapshotCollection(String snapshotEventsCollectionName) {
        return DefaultMongoTemplate.builder().mongoDatabase(this.database()).domainEventsCollectionName(this.domainEventsCollectionName).snapshotEventsCollectionName(snapshotEventsCollectionName).sagasCollectionName(this.sagasCollectionName).deadLetterCollectionName(this.deadLetterCollectionName).trackingTokensCollectionName(this.trackingTokensCollectionName).build();
    }

    public DefaultMongoTemplate withDomainEventsCollection(String domainEventsCollectionName) {
        return DefaultMongoTemplate.builder().mongoDatabase(this.database()).domainEventsCollectionName(domainEventsCollectionName).snapshotEventsCollectionName(this.snapshotEventsCollectionName).sagasCollectionName(this.sagasCollectionName).deadLetterCollectionName(this.deadLetterCollectionName).trackingTokensCollectionName(this.trackingTokensCollectionName).build();
    }

    public DefaultMongoTemplate withSagasCollection(String sagasCollectionName) {
        return DefaultMongoTemplate.builder().mongoDatabase(this.database()).domainEventsCollectionName(this.domainEventsCollectionName).snapshotEventsCollectionName(this.snapshotEventsCollectionName).sagasCollectionName(sagasCollectionName).deadLetterCollectionName(this.deadLetterCollectionName).trackingTokensCollectionName(this.trackingTokensCollectionName).build();
    }

    public DefaultMongoTemplate withDeadLetterCollection(String deadLetterCollectionName) {
        return DefaultMongoTemplate.builder().mongoDatabase(this.database()).domainEventsCollectionName(this.domainEventsCollectionName).snapshotEventsCollectionName(this.snapshotEventsCollectionName).sagasCollectionName(this.sagasCollectionName).deadLetterCollectionName(deadLetterCollectionName).trackingTokensCollectionName(this.trackingTokensCollectionName).build();
    }

    public DefaultMongoTemplate withTrackingTokenCollection(String trackingTokensCollectionName) {
        return DefaultMongoTemplate.builder().mongoDatabase(this.database()).domainEventsCollectionName(this.domainEventsCollectionName).snapshotEventsCollectionName(this.snapshotEventsCollectionName).sagasCollectionName(this.sagasCollectionName).deadLetterCollectionName(this.deadLetterCollectionName).trackingTokensCollectionName(trackingTokensCollectionName).build();
    }

    @Override
    public MongoCollection<Document> trackingTokensCollection() {
        return this.database().getCollection(this.trackingTokensCollectionName);
    }

    @Override
    public MongoCollection<Document> eventCollection() {
        return this.database().getCollection(this.domainEventsCollectionName);
    }

    @Override
    public MongoCollection<Document> snapshotCollection() {
        return this.database().getCollection(this.snapshotEventsCollectionName);
    }

    @Override
    public MongoCollection<Document> sagaCollection() {
        return this.database().getCollection(this.sagasCollectionName);
    }

    @Override
    public MongoCollection<Document> deadLetterCollection() {
        return this.database().getCollection(this.deadLetterCollectionName);
    }

    public static class Builder
    extends AbstractMongoTemplate.Builder {
        private String domainEventsCollectionName = "domainevents";
        private String snapshotEventsCollectionName = "snapshotevents";
        private String trackingTokensCollectionName = "trackingtokens";
        private String sagasCollectionName = "sagas";
        private String deadLetterCollectionName = "deadletters";

        @Override
        public Builder mongoDatabase(MongoClient mongoClient) {
            super.mongoDatabase(mongoClient);
            return this;
        }

        @Override
        public Builder mongoDatabase(MongoClient mongoClient, String databaseName) {
            super.mongoDatabase(mongoClient, databaseName);
            return this;
        }

        @Override
        public Builder mongoDatabase(MongoDatabase mongoDatabase) {
            super.mongoDatabase(mongoDatabase);
            return this;
        }

        public Builder domainEventsCollectionName(String domainEventsCollectionName) {
            this.assertName(domainEventsCollectionName, "domainEventsCollectionName");
            this.domainEventsCollectionName = domainEventsCollectionName;
            return this;
        }

        public Builder snapshotEventsCollectionName(String snapshotEventsCollectionName) {
            this.assertName(snapshotEventsCollectionName, "snapshotEventsCollectionName");
            this.snapshotEventsCollectionName = snapshotEventsCollectionName;
            return this;
        }

        public Builder trackingTokensCollectionName(String trackingTokensCollectionName) {
            this.assertName(trackingTokensCollectionName, "trackingTokensCollectionName");
            this.trackingTokensCollectionName = trackingTokensCollectionName;
            return this;
        }

        public Builder sagasCollectionName(String sagasCollectionName) {
            this.assertName(sagasCollectionName, "sagasCollectionName");
            this.sagasCollectionName = sagasCollectionName;
            return this;
        }

        public Builder deadLetterCollectionName(String deadLetterCollectionName) {
            this.assertName(deadLetterCollectionName, "deadLetterCollectionName");
            this.deadLetterCollectionName = deadLetterCollectionName;
            return this;
        }

        private void assertName(String collectionName, String collectionDescription) {
            BuilderUtils.assertThat((Object)collectionName, name -> Objects.nonNull(name) && !"".equals(name), (String)String.format("The %s may not be null", collectionDescription));
        }

        public DefaultMongoTemplate build() {
            return new DefaultMongoTemplate(this);
        }
    }
}

