/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.autoconfig;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.sql.DataSource;
import org.axonframework.common.Registration;
import org.axonframework.extensions.multitenancy.TenantWrappedTransactionManager;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.TenantProvider;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
@ConditionalOnProperty(value={"axon.multi-tenancy.enabled"}, matchIfMissing=true)
@ConditionalOnBean(name={"tenantDataSourceResolver"})
public class MultiTenantDataSourceManager
implements MultiTenantAwareComponent {
    private static final Logger logger = LoggerFactory.getLogger(MultiTenantDataSourceManager.class);
    private final Map<TenantDescriptor, Object> tenantDataSources = new ConcurrentHashMap<TenantDescriptor, Object>();
    private AbstractRoutingDataSource multiTenantDataSource;
    private final DataSourceProperties properties;
    private final TargetTenantResolver<Message<?>> tenantResolver;
    private final Function<TenantDescriptor, DataSourceProperties> dataSourcePropertyResolver;

    public MultiTenantDataSourceManager(DataSourceProperties properties, TargetTenantResolver<Message<?>> tenantResolver, @Autowired(required=false) Function<TenantDescriptor, DataSourceProperties> dataSourcePropertyResolver) {
        this.properties = properties;
        this.tenantResolver = tenantResolver;
        this.dataSourcePropertyResolver = dataSourcePropertyResolver;
    }

    @Primary
    @Bean
    public DataSource tenantDataSource(TenantProvider tenantProvider) {
        this.multiTenantDataSource = new AbstractRoutingDataSource(){

            protected Object determineCurrentLookupKey() {
                if (!CurrentUnitOfWork.isStarted()) {
                    return TenantWrappedTransactionManager.getCurrentTenant();
                }
                Message message = CurrentUnitOfWork.get().getMessage();
                return MultiTenantDataSourceManager.this.tenantResolver.resolveTenant(message, MultiTenantDataSourceManager.this.tenantDataSources.keySet());
            }
        };
        this.multiTenantDataSource.setTargetDataSources(Collections.unmodifiableMap(this.tenantDataSources));
        DataSource defaultDatasource = this.defaultDataSource();
        this.multiTenantDataSource.setDefaultTargetDataSource((Object)defaultDatasource);
        this.multiTenantDataSource.afterPropertiesSet();
        tenantProvider.subscribe((MultiTenantAwareComponent)this);
        return this.multiTenantDataSource;
    }

    private DataSource defaultDataSource() {
        DriverManagerDataSource defaultDataSource = new DriverManagerDataSource();
        defaultDataSource.setDriverClassName(this.properties.getDriverClassName());
        defaultDataSource.setUrl(this.properties.getUrl());
        defaultDataSource.setUsername(this.properties.getUsername());
        defaultDataSource.setPassword(this.properties.getPassword());
        return defaultDataSource;
    }

    private boolean tenantIsAbsent(TenantDescriptor tenantDescriptor) {
        return !this.tenantDataSources.containsKey(tenantDescriptor);
    }

    AbstractRoutingDataSource getMultiTenantDataSource() {
        return this.multiTenantDataSource;
    }

    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        this.register(tenantDescriptor);
        return () -> this.unregister(tenantDescriptor) != null;
    }

    private void register(TenantDescriptor tenant) {
        if (this.tenantIsAbsent(tenant) && this.dataSourcePropertyResolver != null) {
            DataSourceProperties dataSourceProperties;
            try {
                dataSourceProperties = this.dataSourcePropertyResolver.apply(tenant);
                logger.debug("[d] Datasource properties resolved for tenant descriptor [{}]", (Object)tenant);
            }
            catch (Exception e) {
                throw new NoSuchTenantException("Could not resolve the tenant!");
            }
            this.addTenant(tenant, dataSourceProperties);
        }
        logger.debug("[d] Tenant [{}] set as current.", (Object)tenant);
    }

    private void addTenant(TenantDescriptor tenant, DataSourceProperties dataSourceProperties) {
        DataSource dataSource = DataSourceBuilder.create().driverClassName(dataSourceProperties.getDriverClassName()).url(dataSourceProperties.getUrl()).username(dataSourceProperties.getUsername()).password(dataSourceProperties.getPassword()).build();
        try (Connection ignored = dataSource.getConnection();){
            this.tenantDataSources.put(tenant, dataSource);
            this.multiTenantDataSource.afterPropertiesSet();
            logger.debug("[d] Tenant '{}' added.", (Object)tenant);
        }
        catch (SQLException t) {
            logger.error("[d] Could not add tenant '{}'", (Object)tenant, (Object)t);
        }
    }

    private DataSource unregister(TenantDescriptor tenantDescriptor) {
        Object removedDataSource = this.tenantDataSources.remove(tenantDescriptor);
        this.multiTenantDataSource.afterPropertiesSet();
        return (DataSource)removedDataSource;
    }

    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        return this.registerTenant(tenantDescriptor);
    }
}

