/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.autoconfig;

import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.multitenancy.autoconfig.MultiTenancyAxonServerAutoConfiguration;
import org.axonframework.extensions.multitenancy.autoconfig.TenantCorrelationProvider;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantConnectPredicate;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.TenantProvider;
import org.axonframework.extensions.multitenancy.components.commandhandeling.MultiTenantCommandBus;
import org.axonframework.extensions.multitenancy.components.commandhandeling.TenantCommandSegmentFactory;
import org.axonframework.extensions.multitenancy.components.deadletterqueue.MultiTenantDeadLetterQueue;
import org.axonframework.extensions.multitenancy.components.deadletterqueue.MultiTenantDeadLetterQueueFactory;
import org.axonframework.extensions.multitenancy.components.eventstore.MultiTenantEventStore;
import org.axonframework.extensions.multitenancy.components.eventstore.TenantEventSegmentFactory;
import org.axonframework.extensions.multitenancy.components.queryhandeling.MultiTenantQueryBus;
import org.axonframework.extensions.multitenancy.components.queryhandeling.MultiTenantQueryUpdateEmitter;
import org.axonframework.extensions.multitenancy.components.queryhandeling.TenantQuerySegmentFactory;
import org.axonframework.extensions.multitenancy.components.queryhandeling.TenantQueryUpdateEmitterSegmentFactory;
import org.axonframework.extensions.multitenancy.components.scheduling.MultiTenantEventScheduler;
import org.axonframework.extensions.multitenancy.components.scheduling.TenantEventSchedulerSegmentFactory;
import org.axonframework.extensions.multitenancy.configuration.MultiTenantEventProcessingModule;
import org.axonframework.extensions.multitenancy.configuration.MultiTenantEventProcessorPredicate;
import org.axonframework.extensions.multitenancy.configuration.MultiTenantStreamableMessageSourceProvider;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.springboot.util.ConditionalOnMissingQualifiedBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnProperty(value={"axon.multi-tenancy.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={MultiTenancyAxonServerAutoConfiguration.class})
public class MultiTenancyAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TenantConnectPredicate tenantFilterPredicate() {
        return tenant -> true;
    }

    @Bean
    @Primary
    @ConditionalOnMissingQualifiedBean(qualifier="!localSegment", beanClass=CommandBus.class)
    public MultiTenantCommandBus multiTenantCommandBus(TenantCommandSegmentFactory tenantCommandSegmentFactory, TargetTenantResolver<?> targetTenantResolver, TenantProvider tenantProvider) {
        MultiTenantCommandBus commandBus = MultiTenantCommandBus.builder().tenantSegmentFactory(tenantCommandSegmentFactory).targetTenantResolver(targetTenantResolver).build();
        tenantProvider.subscribe((MultiTenantAwareComponent)commandBus);
        return commandBus;
    }

    @Bean
    @Primary
    public MultiTenantQueryBus multiTenantQueryBus(TenantQuerySegmentFactory tenantQuerySegmentFactory, TargetTenantResolver<?> targetTenantResolver, TenantProvider tenantProvider) {
        MultiTenantQueryBus queryBus = MultiTenantQueryBus.builder().tenantSegmentFactory(tenantQuerySegmentFactory).targetTenantResolver(targetTenantResolver).build();
        tenantProvider.subscribe((MultiTenantAwareComponent)queryBus);
        return queryBus;
    }

    @Bean
    @Primary
    public QueryUpdateEmitter multiTenantQueryUpdateEmitter(TenantQueryUpdateEmitterSegmentFactory tenantQueryUpdateEmitterSegmentFactory, TargetTenantResolver<?> targetTenantResolver, TenantProvider tenantProvider) {
        MultiTenantQueryUpdateEmitter multiTenantQueryUpdateEmitter = MultiTenantQueryUpdateEmitter.builder().tenantSegmentFactory(tenantQueryUpdateEmitterSegmentFactory).targetTenantResolver(targetTenantResolver).build();
        tenantProvider.subscribe((MultiTenantAwareComponent)multiTenantQueryUpdateEmitter);
        return multiTenantQueryUpdateEmitter;
    }

    @Bean
    @Primary
    public MultiTenantEventStore multiTenantEventStore(TenantEventSegmentFactory tenantEventSegmentFactory, TargetTenantResolver<?> targetTenantResolver, TenantProvider tenantProvider) {
        MultiTenantEventStore multiTenantEventStore = MultiTenantEventStore.builder().tenantSegmentFactory(tenantEventSegmentFactory).targetTenantResolver(targetTenantResolver).build();
        tenantProvider.subscribe((MultiTenantAwareComponent)multiTenantEventStore);
        return multiTenantEventStore;
    }

    @Bean
    @Primary
    public MultiTenantEventScheduler multiTenantEventScheduler(TenantEventSchedulerSegmentFactory tenantEventSchedulerSegmentFactory, TargetTenantResolver<?> targetTenantResolver, TenantProvider tenantProvider) {
        MultiTenantEventScheduler multiTenantEventScheduler = MultiTenantEventScheduler.builder().tenantSegmentFactory(tenantEventSchedulerSegmentFactory).targetTenantResolver(targetTenantResolver).build();
        tenantProvider.subscribe((MultiTenantAwareComponent)multiTenantEventScheduler);
        return multiTenantEventScheduler;
    }

    @Bean
    public MultiTenantDeadLetterQueueFactory<EventMessage<?>> multiTenantDeadLetterQueueFactory(TenantProvider tenantProvider, TargetTenantResolver<?> targetTenantResolver) {
        ConcurrentHashMap multiTenantDeadLetterQueue = new ConcurrentHashMap();
        return processingGroup -> multiTenantDeadLetterQueue.computeIfAbsent(processingGroup, key -> {
            MultiTenantDeadLetterQueue deadLetterQueue = MultiTenantDeadLetterQueue.builder().targetTenantResolver(targetTenantResolver).processingGroup(processingGroup).build();
            tenantProvider.subscribe((MultiTenantAwareComponent)deadLetterQueue);
            return deadLetterQueue;
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public MultiTenantStreamableMessageSourceProvider multiTenantStreamableMessageSourceProvider() {
        return (defaultTenantSource, processorName, tenantDescriptor, configuration) -> defaultTenantSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public MultiTenantEventProcessorPredicate multiTenantEventProcessorPredicate() {
        return MultiTenantEventProcessorPredicate.enableMultiTenancy();
    }

    @Bean
    public MultiTenantEventProcessingModule multiTenantEventProcessingModule(TenantProvider tenantProvider, MultiTenantStreamableMessageSourceProvider multiTenantStreamableMessageSourceProvider, MultiTenantDeadLetterQueueFactory<EventMessage<?>> multiTenantDeadLetterQueueFactory, MultiTenantEventProcessorPredicate multiTenantEventProcessorPredicate) {
        return new MultiTenantEventProcessingModule(tenantProvider, multiTenantStreamableMessageSourceProvider, multiTenantDeadLetterQueueFactory, multiTenantEventProcessorPredicate);
    }

    @Bean
    @ConditionalOnProperty(name={"axon.multi-tenancy.use-metadata-helper"}, matchIfMissing=true)
    public TargetTenantResolver<Message<?>> targetTenantResolver() {
        return (message, tenants) -> TenantDescriptor.tenantWithId((String)((String)message.getMetaData().getOrDefault((Object)"tenantId", (Object)"unknownTenant")));
    }

    @Bean
    @ConditionalOnProperty(name={"axon.multi-tenancy.use-metadata-helper"}, matchIfMissing=true)
    public CorrelationDataProvider tenantCorrelationProvider() {
        return new TenantCorrelationProvider("tenantId");
    }
}

