/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.autoconfig;

import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSource;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceFactory;
import org.axonframework.common.StringUtils;
import org.axonframework.extensions.multitenancy.autoconfig.MultiTenantPersistentStreamMessageSource;
import org.axonframework.extensions.multitenancy.autoconfig.TenantPersistentStreamMessageSourceFactory;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.TenantProvider;
import org.axonframework.springboot.autoconfig.AxonServerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(value={"axon.axonserver.enabled", "axon.multi-tenancy.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={AxonServerAutoConfiguration.class})
public class MultiTenantPersistentStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PersistentStreamMessageSourceFactory persistentStreamMessageSourceFactory(TenantProvider tenantProvider, TenantPersistentStreamMessageSourceFactory tenantPersistentStreamMessageSourceFactory) {
        return (name, persistentStreamProperties, scheduler, batchSize, context, configuration) -> {
            MultiTenantPersistentStreamMessageSource component = new MultiTenantPersistentStreamMessageSource(name, persistentStreamProperties, scheduler, batchSize, context, configuration, tenantPersistentStreamMessageSourceFactory);
            tenantProvider.subscribe((MultiTenantAwareComponent)component);
            return component;
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantPersistentStreamMessageSourceFactory tenantPersistentStreamMessageSourceFactory() {
        return (name, persistentStreamProperties, scheduler, batchSize, context, configuration, tenantDescriptor) -> new PersistentStreamMessageSource(name + "@" + tenantDescriptor.tenantId(), configuration, persistentStreamProperties, scheduler, batchSize, StringUtils.emptyOrNull((String)context) ? tenantDescriptor.tenantId() : context);
    }
}

