/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.autoconfig;

import io.axoniq.axonserver.connector.event.PersistentStreamProperties;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSource;
import org.axonframework.common.Registration;
import org.axonframework.config.Configuration;
import org.axonframework.extensions.multitenancy.autoconfig.TenantPersistentStreamMessageSourceFactory;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.eventstore.MultiTenantSubscribableMessageSource;

public class MultiTenantPersistentStreamMessageSource
extends PersistentStreamMessageSource
implements MultiTenantAwareComponent,
MultiTenantSubscribableMessageSource<PersistentStreamMessageSource> {
    private final String name;
    private final Configuration configuration;
    private final TenantPersistentStreamMessageSourceFactory tenantPersistentStreamMessageSourceFactory;
    private final Map<TenantDescriptor, PersistentStreamMessageSource> tenantSegments = new ConcurrentHashMap<TenantDescriptor, PersistentStreamMessageSource>();
    private final PersistentStreamProperties persistentStreamProperties;
    private final ScheduledExecutorService scheduler;
    private final int batchSize;
    private final String context;

    public MultiTenantPersistentStreamMessageSource(String name, PersistentStreamProperties persistentStreamProperties, ScheduledExecutorService scheduler, int batchSize, String context, Configuration configuration, TenantPersistentStreamMessageSourceFactory tenantPersistentStreamMessageSourceFactory) {
        super(name, configuration, persistentStreamProperties, scheduler, batchSize, context);
        this.tenantPersistentStreamMessageSourceFactory = tenantPersistentStreamMessageSourceFactory;
        this.name = name;
        this.configuration = configuration;
        this.persistentStreamProperties = persistentStreamProperties;
        this.scheduler = scheduler;
        this.batchSize = batchSize;
        this.context = context;
    }

    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        PersistentStreamMessageSource tenantSegment = this.tenantPersistentStreamMessageSourceFactory.build(this.name, this.persistentStreamProperties, this.scheduler, this.batchSize, this.context, this.configuration, tenantDescriptor);
        this.tenantSegments.putIfAbsent(tenantDescriptor, tenantSegment);
        return () -> {
            PersistentStreamMessageSource removed = this.tenantSegments.remove(tenantDescriptor);
            return removed != null;
        };
    }

    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        return this.registerTenant(tenantDescriptor);
    }

    public Map<TenantDescriptor, PersistentStreamMessageSource> tenantSegments() {
        return Collections.unmodifiableMap(this.tenantSegments);
    }
}

