/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.autoconfig;

import io.axoniq.axonserver.connector.ResultStream;
import io.axoniq.axonserver.grpc.admin.ContextOverview;
import io.axoniq.axonserver.grpc.admin.ContextUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.common.Registration;
import org.axonframework.common.StringUtils;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.TenantConnectPredicate;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.TenantProvider;
import org.axonframework.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerTenantProvider
implements TenantProvider,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(AxonServerTenantProvider.class);
    private final List<MultiTenantAwareComponent> tenantAwareComponents = new CopyOnWriteArrayList<MultiTenantAwareComponent>();
    private final Set<TenantDescriptor> tenantDescriptors = new HashSet<TenantDescriptor>();
    private final String preDefinedContexts;
    private final TenantConnectPredicate tenantConnectPredicate;
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final String ADMIN_CTX = "_admin";
    private ConcurrentHashMap<TenantDescriptor, List<Registration>> registrationMap = new ConcurrentHashMap();

    public AxonServerTenantProvider(String preDefinedContexts, TenantConnectPredicate tenantConnectPredicate, AxonServerConnectionManager axonServerConnectionManager) {
        this.preDefinedContexts = preDefinedContexts;
        this.tenantConnectPredicate = tenantConnectPredicate;
        this.axonServerConnectionManager = axonServerConnectionManager;
    }

    public void start() {
        this.tenantDescriptors.addAll(this.getInitialTenants());
        this.tenantDescriptors.forEach(this::addTenant);
        if (this.preDefinedContexts == null || this.preDefinedContexts.isEmpty()) {
            this.subscribeToUpdates();
        }
    }

    private List<TenantDescriptor> getInitialTenants() {
        List<Object> initialTenants = Collections.emptyList();
        try {
            initialTenants = StringUtils.nonEmptyOrNull((String)this.preDefinedContexts) ? Arrays.stream(this.preDefinedContexts.split(",")).map(String::trim).map(TenantDescriptor::tenantWithId).collect(Collectors.toList()) : this.getTenantsAPI();
        }
        catch (Exception e) {
            logger.error("Error while getting initial tenants", (Throwable)e);
        }
        return initialTenants;
    }

    private void subscribeToUpdates() {
        try {
            ResultStream contextUpdatesStream = this.axonServerConnectionManager.getConnection("_admin").adminChannel().subscribeToContextUpdates();
            contextUpdatesStream.onAvailable(() -> {
                try {
                    ContextUpdate contextUpdate = (ContextUpdate)contextUpdatesStream.nextIfAvailable();
                    if (contextUpdate != null) {
                        switch (contextUpdate.getType()) {
                            case CREATED: {
                                this.handleContextCreated(contextUpdate);
                                break;
                            }
                            case DELETED: {
                                this.removeTenant(TenantDescriptor.tenantWithId((String)contextUpdate.getContext()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while subscribing to context updates", (Throwable)e);
        }
    }

    private void handleContextCreated(ContextUpdate contextUpdate) {
        try {
            TenantDescriptor newTenant = this.toTenantDescriptor((ContextOverview)this.axonServerConnectionManager.getConnection("_admin").adminChannel().getContextOverview(contextUpdate.getContext()).get());
            if (this.tenantConnectPredicate.test((Object)newTenant) && !this.tenantDescriptors.contains(newTenant)) {
                this.addTenant(newTenant);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<TenantDescriptor> getTenants() {
        return new ArrayList<TenantDescriptor>(this.tenantDescriptors);
    }

    private List<TenantDescriptor> getTenantsAPI() {
        return ((List)this.axonServerConnectionManager.getConnection("_admin").adminChannel().getAllContexts().join()).stream().map(this::toTenantDescriptor).filter((Predicate<TenantDescriptor>)this.tenantConnectPredicate).collect(Collectors.toList());
    }

    private TenantDescriptor toTenantDescriptor(ContextOverview context) {
        HashMap<String, String> metaDataMap = new HashMap<String, String>(context.getMetaDataMap());
        metaDataMap.putIfAbsent("replicationGroup", context.getReplicationGroup().getName());
        return new TenantDescriptor(context.getName(), metaDataMap);
    }

    protected void addTenant(TenantDescriptor tenantDescriptor) {
        this.tenantDescriptors.add(tenantDescriptor);
        this.tenantAwareComponents.forEach(bus -> this.registrationMap.computeIfAbsent(tenantDescriptor, t -> new CopyOnWriteArrayList()).add(bus.registerAndStartTenant(tenantDescriptor)));
    }

    protected void removeTenant(TenantDescriptor tenantDescriptor) {
        if (this.tenantDescriptors.contains(tenantDescriptor) && this.tenantDescriptors.remove(tenantDescriptor)) {
            List<Registration> registrations = this.registrationMap.remove(tenantDescriptor);
            if (registrations != null && !registrations.isEmpty()) {
                registrations.forEach(Registration::cancel);
            }
            this.axonServerConnectionManager.disconnect(tenantDescriptor.tenantId());
        }
    }

    public Registration subscribe(MultiTenantAwareComponent bus) {
        this.tenantAwareComponents.add(bus);
        this.tenantDescriptors.forEach(tenantDescriptor -> this.registrationMap.computeIfAbsent((TenantDescriptor)tenantDescriptor, t -> new CopyOnWriteArrayList()).add(bus.registerTenant(tenantDescriptor)));
        return () -> {
            this.registrationMap.forEach((tenant, registrationList) -> {
                registrationList.forEach(Registration::cancel);
                this.tenantAwareComponents.removeIf(t -> true);
                this.axonServerConnectionManager.disconnect(tenant.tenantId());
            });
            this.registrationMap = new ConcurrentHashMap();
            return true;
        };
    }

    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry lifecycle) {
        lifecycle.onStart(1073741843, this::start);
        lifecycle.onShutdown(1073741843, this::shutdown);
    }

    private void shutdown() {
        this.registrationMap.forEach((tenant, registrationList) -> registrationList.forEach(Registration::cancel));
    }
}

