/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.autoconfig;

import io.axoniq.axonserver.connector.AxonServerConnection;
import io.axoniq.axonserver.connector.admin.AdminChannel;
import io.axoniq.axonserver.connector.control.ControlChannel;
import io.axoniq.axonserver.connector.control.ProcessorInstructionHandler;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorControlService;
import org.axonframework.common.Registration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.eventhandeling.MultiTenantEventProcessor;
import org.axonframework.lifecycle.StartHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantEventProcessorControlService
extends EventProcessorControlService
implements MultiTenantAwareComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public MultiTenantEventProcessorControlService(AxonServerConnectionManager axonServerConnectionManager, EventProcessingConfiguration eventProcessingConfiguration, AxonServerConfiguration axonServerConfiguration) {
        this(axonServerConnectionManager, eventProcessingConfiguration, axonServerConfiguration.getContext(), axonServerConfiguration.getEventhandling().getProcessors());
    }

    public MultiTenantEventProcessorControlService(AxonServerConnectionManager axonServerConnectionManager, EventProcessingConfiguration eventProcessingConfiguration, String context, Map<String, AxonServerConfiguration.Eventhandling.ProcessorSettings> processorConfig) {
        super(axonServerConnectionManager, eventProcessingConfiguration, context, processorConfig);
    }

    @StartHandler(phase=0x40000009)
    public void start() {
        if (this.axonServerConnectionManager == null || this.eventProcessingConfiguration == null) {
            return;
        }
        HashMap contextToConnection = new HashMap();
        Map eventProcessors = this.eventProcessingConfiguration.eventProcessors();
        Map<String, String> strategiesPerProcessor = this.strategiesPerProcessor(eventProcessors);
        eventProcessors.forEach((processorAndContext, processor) -> {
            if (processor instanceof MultiTenantEventProcessor) {
                return;
            }
            String processorName = MultiTenantEventProcessorControlService.processorNameFromCombination(processorAndContext);
            String context = MultiTenantEventProcessorControlService.contextFromCombination(processorAndContext);
            AxonServerConnection connection = contextToConnection.computeIfAbsent(context, arg_0 -> ((AxonServerConnectionManager)this.axonServerConnectionManager).getConnection(arg_0));
            this.registerInstructionHandler(connection.controlChannel(), (String)processorAndContext, (EventProcessor)processor);
            String strategyForProcessor = (String)strategiesPerProcessor.get(processorName);
            if (strategyForProcessor != null) {
                this.setLoadBalancingStrategy(connection.adminChannel(), processorName, strategyForProcessor);
            }
        });
    }

    private Map<String, String> strategiesPerProcessor(Map<String, EventProcessor> eventProcessors) {
        List processorNames = eventProcessors.entrySet().stream().filter(entry -> !(entry.getValue() instanceof MultiTenantEventProcessor)).map(Map.Entry::getKey).map(MultiTenantEventProcessorControlService::processorNameFromCombination).collect(Collectors.toList());
        return this.processorConfig.entrySet().stream().filter(entry -> {
            if (!processorNames.contains(entry.getKey())) {
                logger.info("Event Processor [{}] is not a registered. Please check the name or register the Event Processor", entry.getKey());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AxonServerConfiguration.Eventhandling.ProcessorSettings)entry.getValue()).getLoadBalancingStrategy()));
    }

    private static String contextFromCombination(String processorAndContext) {
        return processorAndContext.substring(processorAndContext.indexOf("@") + 1);
    }

    private void registerInstructionHandler(ControlChannel controlChannel, String processorAndContext, EventProcessor processor) {
        controlChannel.registerEventProcessor(processorAndContext, this.infoSupplier(processor), (ProcessorInstructionHandler)new EventProcessorControlService.AxonProcessorInstructionHandler(processor, processorAndContext));
    }

    private void setLoadBalancingStrategy(AdminChannel adminChannel, String processorName, String strategy) {
        Optional<String> optionalIdentifier = this.tokenStoreIdentifierFor(processorName);
        if (!optionalIdentifier.isPresent()) {
            logger.warn("Cannot find token store identifier for processor [{}]. Load balancing cannot be configured without this identifier.", (Object)processorName);
            return;
        }
        String tokenStoreIdentifier = optionalIdentifier.get();
        adminChannel.loadBalanceEventProcessor(processorName, tokenStoreIdentifier, strategy).whenComplete((r, e) -> {
            if (e == null) {
                logger.debug("Successfully requested to load balance processor [{}] with strategy [{}].", (Object)processorName, (Object)strategy);
                return;
            }
            logger.warn("Requesting to load balance processor [{}] with strategy [{}] failed.", new Object[]{processorName, strategy, e});
        });
        if (((AxonServerConfiguration.Eventhandling.ProcessorSettings)this.processorConfig.get(processorName)).isAutomaticBalancing()) {
            adminChannel.setAutoLoadBalanceStrategy(processorName, tokenStoreIdentifier, strategy).whenComplete((r, e) -> {
                if (e == null) {
                    logger.debug("Successfully requested to automatically balance processor [{}] with strategy [{}].", (Object)processorName, (Object)strategy);
                    return;
                }
                logger.warn("Requesting to automatically balance processor [{}] with strategy [{}] failed.", new Object[]{processorName, strategy, e});
            });
        }
    }

    private Optional<String> tokenStoreIdentifierFor(String processorName) {
        return this.eventProcessingConfiguration.tokenStore(processorName).retrieveStorageIdentifier();
    }

    private static String processorNameFromCombination(String processorAndContext) {
        return processorAndContext.substring(0, processorAndContext.indexOf("@"));
    }

    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        return () -> true;
    }

    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        if (this.axonServerConnectionManager == null || this.eventProcessingConfiguration == null) {
            return () -> true;
        }
        Map eventProcessors = this.eventProcessingConfiguration.eventProcessors();
        eventProcessors.forEach((name, processor) -> {
            if (processor instanceof MultiTenantEventProcessor || !name.contains(tenantDescriptor.tenantId())) {
                return;
            }
            ControlChannel controlChannel = this.axonServerConnectionManager.getConnection(tenantDescriptor.tenantId()).controlChannel();
            EventProcessorControlService.AxonProcessorInstructionHandler instructionHandler = new EventProcessorControlService.AxonProcessorInstructionHandler(processor, name);
            controlChannel.registerEventProcessor(name, this.infoSupplier((EventProcessor)processor), (ProcessorInstructionHandler)instructionHandler);
        });
        return () -> true;
    }
}

