/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.axonframework.common.Registration;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageDispatchInterceptorSupport;

public interface MultiTenantDispatchInterceptorSupport<M extends Message<?>, B extends MessageDispatchInterceptorSupport<M>>
extends MessageDispatchInterceptorSupport<M> {
    public Map<TenantDescriptor, B> tenantSegments();

    public List<MessageDispatchInterceptor<? super M>> getDispatchInterceptors();

    public Map<TenantDescriptor, List<Registration>> getDispatchInterceptorsRegistration();

    default public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super M> dispatchInterceptor) {
        this.getDispatchInterceptors().add(dispatchInterceptor);
        HashMap newRegistrations = new HashMap();
        this.tenantSegments().forEach((tenant, bus) -> newRegistrations.computeIfAbsent(tenant, t -> new CopyOnWriteArrayList()).add(bus.registerDispatchInterceptor(dispatchInterceptor)));
        this.getDispatchInterceptorsRegistration().putAll(newRegistrations);
        return () -> newRegistrations.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(Registration::cancel).reduce((prev, acc) -> prev != false && acc != false).orElse(false);
    }
}

