/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.deadletterqueue;

import java.util.function.Predicate;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.multitenancy.TenantWrappedTransactionManager;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterProcessor;

public class MultiTenantDeadLetterProcessor
implements SequencedDeadLetterProcessor<EventMessage<?>> {
    private TenantDescriptor tenantDescriptor;
    private final SequencedDeadLetterProcessor<EventMessage<?>> delegate;

    public MultiTenantDeadLetterProcessor(SequencedDeadLetterProcessor<EventMessage<?>> delegate) {
        this.delegate = delegate;
    }

    private MultiTenantDeadLetterProcessor(TenantDescriptor tenantDescriptor, SequencedDeadLetterProcessor<EventMessage<?>> delegate) {
        this.tenantDescriptor = tenantDescriptor;
        this.delegate = delegate;
    }

    public MultiTenantDeadLetterProcessor forTenant(TenantDescriptor tenantDescriptor) {
        return new MultiTenantDeadLetterProcessor(tenantDescriptor, this.delegate);
    }

    public boolean process(Predicate<DeadLetter<? extends EventMessage<?>>> sequenceFilter) {
        if (this.tenantDescriptor == null) {
            throw new IllegalStateException("Tenant descriptor is not set. Use forTenant method to set it.");
        }
        return new TenantWrappedTransactionManager(this.tenantDescriptor).fetchInTransaction(() -> this.delegate.process(sequenceFilter));
    }

    public boolean processAny() {
        if (this.tenantDescriptor == null) {
            throw new IllegalStateException("Tenant descriptor is not set. Use forTenant method to set it.");
        }
        return new TenantWrappedTransactionManager(this.tenantDescriptor).fetchInTransaction(() -> this.delegate.processAny());
    }
}

