/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.queryhandeling;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.MultiTenantDispatchInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.queryhandeling.TenantQueryUpdateEmitterSegmentFactory;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.UpdateHandlerRegistration;

public class MultiTenantQueryUpdateEmitter
implements QueryUpdateEmitter,
MultiTenantAwareComponent,
MultiTenantDispatchInterceptorSupport<SubscriptionQueryUpdateMessage<?>, QueryUpdateEmitter> {
    private final Map<TenantDescriptor, QueryUpdateEmitter> tenantSegments = new ConcurrentHashMap<TenantDescriptor, QueryUpdateEmitter>();
    private final Map<TenantDescriptor, List<UpdateHandlerRegistration<?>>> updateHandlersRegistration = new ConcurrentHashMap();
    private final List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> dispatchInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final TenantQueryUpdateEmitterSegmentFactory tenantSegmentFactory;
    private final TargetTenantResolver<Message<?>> targetTenantResolver;

    protected MultiTenantQueryUpdateEmitter(Builder builder) {
        builder.validate();
        this.tenantSegmentFactory = builder.tenantSegmentFactory;
        this.targetTenantResolver = builder.targetTenantResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <U> void emit(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, U>> filter, @Nonnull SubscriptionQueryUpdateMessage<U> update) {
        QueryUpdateEmitter tenantEmitter = this.resolveTenant((Message<?>)update);
        tenantEmitter.emit(filter, update);
    }

    public <U> void emit(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, U>> filter, U update) {
        Message message = update instanceof Message ? (Message)update : CurrentUnitOfWork.get().getMessage();
        if (message == null) {
            throw new NoSuchTenantException("Can't find any tenant identifier for this message!");
        }
        QueryUpdateEmitter tenantEmitter = this.resolveTenant(message);
        tenantEmitter.emit(filter, update);
    }

    public <Q, U> void emit(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nonnull SubscriptionQueryUpdateMessage<U> update) {
        QueryUpdateEmitter tenantEmitter = this.resolveTenant((Message<?>)update);
        tenantEmitter.emit(queryType, filter, update);
    }

    public <Q, U> void emit(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, U update) {
        Message message = update instanceof Message ? (Message)update : CurrentUnitOfWork.get().getMessage();
        if (message == null) {
            throw new NoSuchTenantException("Can't find any tenant identifier for this message!");
        }
        QueryUpdateEmitter tenantEmitter = this.resolveTenant(message);
        tenantEmitter.emit(queryType, filter, update);
    }

    public void complete(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, ?>> filter) {
        throw new UnsupportedOperationException("Invoke operation directly on tenant segment. Use: MultiTenantQueryUpdateEmitter::getTenant");
    }

    public <Q> void complete(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter) {
        throw new UnsupportedOperationException("Invoke operation directly on tenant segment. Use: MultiTenantQueryUpdateEmitter::getTenant");
    }

    public void completeExceptionally(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, ?>> filter, @Nonnull Throwable cause) {
        throw new UnsupportedOperationException("Invoke operation directly on tenant segment. Use: MultiTenantQueryUpdateEmitter::getTenant");
    }

    public <Q> void completeExceptionally(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nonnull Throwable cause) {
        throw new UnsupportedOperationException("Invoke operation directly on tenant segment. Use: MultiTenantQueryUpdateEmitter::getTenant");
    }

    public boolean queryUpdateHandlerRegistered(@Nonnull SubscriptionQueryMessage<?, ?, ?> query) {
        return this.tenantSegments.values().stream().anyMatch(segment -> segment.queryUpdateHandlerRegistered(query));
    }

    public <U> UpdateHandlerRegistration<U> registerUpdateHandler(SubscriptionQueryMessage<?, ?, ?> query, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        return this.registerUpdateHandler(query, updateBufferSize);
    }

    public <U> UpdateHandlerRegistration<U> registerUpdateHandler(@Nonnull SubscriptionQueryMessage<?, ?, ?> query, int updateBufferSize) {
        QueryUpdateEmitter queryUpdateEmitter = this.resolveTenant((Message<?>)query);
        UpdateHandlerRegistration updateHandlerRegistration = queryUpdateEmitter.registerUpdateHandler(query, updateBufferSize);
        this.updateHandlersRegistration.computeIfAbsent(this.targetTenantResolver.resolveTenant((Message<?>)query, (Collection<TenantDescriptor>)this.tenantSegments.keySet()), t -> new CopyOnWriteArrayList()).add(updateHandlerRegistration);
        return updateHandlerRegistration;
    }

    public Set<SubscriptionQueryMessage<?, ?, ?>> activeSubscriptions() {
        throw new UnsupportedOperationException();
    }

    private QueryUpdateEmitter resolveTenant(Message<?> update) {
        TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant(update, this.tenantSegments.keySet());
        QueryUpdateEmitter tenantQueryBus = this.tenantSegments.get(tenantDescriptor);
        if (tenantQueryBus == null) {
            throw new NoSuchTenantException(tenantDescriptor.tenantId());
        }
        return tenantQueryBus;
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        return this.registerAndStartTenant(tenantDescriptor);
    }

    public QueryUpdateEmitter getTenant(TenantDescriptor tenantDescriptor) {
        return this.tenantSegments.get(tenantDescriptor);
    }

    private QueryUpdateEmitter unregisterTenant(TenantDescriptor tenantDescriptor) {
        List<Registration> registrations;
        List<UpdateHandlerRegistration<?>> updateHandlerRegistrations = this.updateHandlersRegistration.remove(tenantDescriptor);
        if (updateHandlerRegistrations != null) {
            updateHandlerRegistrations.forEach(it -> it.getRegistration().cancel());
        }
        if ((registrations = this.dispatchInterceptorsRegistration.remove(tenantDescriptor)) != null) {
            registrations.forEach(Registration::cancel);
        }
        return this.tenantSegments.remove(tenantDescriptor);
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        this.tenantSegments.computeIfAbsent(tenantDescriptor, tenant -> {
            QueryUpdateEmitter tenantSegment = (QueryUpdateEmitter)this.tenantSegmentFactory.apply(tenant);
            this.dispatchInterceptors.forEach(dispatchInterceptor -> this.dispatchInterceptorsRegistration.computeIfAbsent((TenantDescriptor)tenant, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerDispatchInterceptor(dispatchInterceptor)));
            return tenantSegment;
        });
        return () -> {
            QueryUpdateEmitter delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    @Override
    public Map<TenantDescriptor, QueryUpdateEmitter> tenantSegments() {
        return this.tenantSegments;
    }

    @Override
    public List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage<?>>> getDispatchInterceptors() {
        return this.dispatchInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getDispatchInterceptorsRegistration() {
        return this.dispatchInterceptorsRegistration;
    }

    public static class Builder {
        protected TargetTenantResolver<Message<?>> targetTenantResolver;
        protected TenantQueryUpdateEmitterSegmentFactory tenantSegmentFactory;

        public Builder tenantSegmentFactory(TenantQueryUpdateEmitterSegmentFactory tenantSegmentFactory) {
            BuilderUtils.assertNonNull((Object)tenantSegmentFactory, (String)"The TenantQueryUpdateEmitterSegmentFactory is a hard requirement");
            this.tenantSegmentFactory = tenantSegmentFactory;
            return this;
        }

        public Builder targetTenantResolver(TargetTenantResolver<Message<?>> targetTenantResolver) {
            BuilderUtils.assertNonNull(targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
            this.targetTenantResolver = targetTenantResolver;
            return this;
        }

        public MultiTenantQueryUpdateEmitter build() {
            return new MultiTenantQueryUpdateEmitter(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.tenantSegmentFactory, (String)"The TenantQueryUpdateEmitterSegmentFactory is a hard requirement and should be provided");
        }
    }
}

