/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy;

import java.util.function.Supplier;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;

public class TenantWrappedTransactionManager
implements TransactionManager {
    private final TransactionManager delegate;
    private final TenantDescriptor tenantDescriptor;
    private static final ThreadLocal<TenantDescriptor> threadLocal = new ThreadLocal();

    public TenantWrappedTransactionManager(TenantDescriptor tenantDescriptor) {
        this.delegate = NoTransactionManager.INSTANCE;
        this.tenantDescriptor = tenantDescriptor;
    }

    public TenantWrappedTransactionManager(TransactionManager delegate, TenantDescriptor tenantDescriptor) {
        this.delegate = delegate;
        this.tenantDescriptor = tenantDescriptor;
    }

    public Transaction startTransaction() {
        threadLocal.set(this.tenantDescriptor);
        Transaction transaction = this.delegate.startTransaction();
        threadLocal.remove();
        return transaction;
    }

    public void executeInTransaction(Runnable task) {
        threadLocal.set(this.tenantDescriptor);
        this.delegate.executeInTransaction(task);
        threadLocal.remove();
    }

    public <T> T fetchInTransaction(Supplier<T> supplier) {
        threadLocal.set(this.tenantDescriptor);
        Object t = this.delegate.fetchInTransaction(supplier);
        threadLocal.remove();
        return (T)t;
    }

    public static TenantDescriptor getCurrentTenant() {
        return threadLocal.get();
    }
}

