/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.commandhandeling;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.MultiTenantDispatchInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.MultiTenantHandlerInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.commandhandeling.TenantCommandSegmentFactory;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;

public class MultiTenantCommandBus
implements CommandBus,
MultiTenantAwareComponent,
MultiTenantDispatchInterceptorSupport<CommandMessage<?>, CommandBus>,
MultiTenantHandlerInterceptorSupport<CommandMessage<?>, CommandBus> {
    private final Map<String, MessageHandler<? super CommandMessage<?>>> handlers = new ConcurrentHashMap();
    private final Map<TenantDescriptor, CommandBus> tenantSegments = new ConcurrentHashMap<TenantDescriptor, CommandBus>();
    private final Map<TenantDescriptor, Registration> subscribeRegistrations = new ConcurrentHashMap<TenantDescriptor, Registration>();
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> dispatchInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> handlerInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final TenantCommandSegmentFactory tenantSegmentFactory;
    private final TargetTenantResolver<CommandMessage<?>> targetTenantResolver;

    protected MultiTenantCommandBus(Builder builder) {
        builder.validate();
        this.tenantSegmentFactory = builder.tenantSegmentFactory;
        this.targetTenantResolver = builder.targetTenantResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <C> void dispatch(@Nonnull CommandMessage<C> command) {
        this.resolveTenant(command).dispatch(command);
    }

    public <C, R> void dispatch(@Nonnull CommandMessage<C> command, @Nonnull CommandCallback<? super C, ? super R> callback) {
        try {
            this.resolveTenant(command).dispatch(command, callback);
        }
        catch (NoSuchTenantException e) {
            callback.onResult(command, GenericCommandResultMessage.asCommandResultMessage((Throwable)((Object)e)));
        }
    }

    public Registration subscribe(@Nonnull String commandName, @Nonnull MessageHandler<? super CommandMessage<?>> handler) {
        this.handlers.computeIfAbsent(commandName, k -> {
            this.tenantSegments.forEach((tenant, segment) -> this.subscribeRegistrations.putIfAbsent((TenantDescriptor)tenant, segment.subscribe(commandName, handler)));
            return handler;
        });
        return () -> this.subscribeRegistrations.values().stream().map(Registration::cancel).reduce((prev, acc) -> prev != false && acc != false).orElse(false);
    }

    @Override
    public Map<TenantDescriptor, CommandBus> tenantSegments() {
        return this.tenantSegments;
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        CommandBus tenantSegment = (CommandBus)this.tenantSegmentFactory.apply(tenantDescriptor);
        this.tenantSegments.putIfAbsent(tenantDescriptor, tenantSegment);
        return () -> {
            CommandBus delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    private CommandBus unregisterTenant(TenantDescriptor tenantDescriptor) {
        Registration removed;
        List<Registration> registrations = this.handlerInterceptorsRegistration.remove(tenantDescriptor);
        if (registrations != null) {
            registrations.forEach(Registration::cancel);
        }
        if ((registrations = this.dispatchInterceptorsRegistration.remove(tenantDescriptor)) != null) {
            registrations.forEach(Registration::cancel);
        }
        if ((removed = this.subscribeRegistrations.remove(tenantDescriptor)) != null) {
            removed.cancel();
        }
        return this.tenantSegments.remove(tenantDescriptor);
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        this.tenantSegments.computeIfAbsent(tenantDescriptor, tenant -> {
            CommandBus tenantSegment = (CommandBus)this.tenantSegmentFactory.apply(tenantDescriptor);
            this.dispatchInterceptors.forEach(dispatchInterceptor -> this.dispatchInterceptorsRegistration.computeIfAbsent((TenantDescriptor)tenant, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerDispatchInterceptor(dispatchInterceptor)));
            this.handlerInterceptors.forEach(handlerInterceptor -> this.handlerInterceptorsRegistration.computeIfAbsent((TenantDescriptor)tenant, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerHandlerInterceptor(handlerInterceptor)));
            this.handlers.forEach((commandName, handler) -> this.subscribeRegistrations.putIfAbsent(tenantDescriptor, tenantSegment.subscribe(commandName, handler)));
            return tenantSegment;
        });
        return () -> {
            CommandBus delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    private CommandBus resolveTenant(CommandMessage<?> commandMessage) {
        TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant(commandMessage, this.tenantSegments.keySet());
        CommandBus tenantCommandBus = this.tenantSegments.get(tenantDescriptor);
        if (tenantCommandBus == null) {
            throw new NoSuchTenantException(tenantDescriptor.tenantId());
        }
        return tenantCommandBus;
    }

    @Override
    public List<MessageDispatchInterceptor<? super CommandMessage<?>>> getDispatchInterceptors() {
        return this.dispatchInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getDispatchInterceptorsRegistration() {
        return this.dispatchInterceptorsRegistration;
    }

    @Override
    public List<MessageHandlerInterceptor<? super CommandMessage<?>>> getHandlerInterceptors() {
        return this.handlerInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getHandlerInterceptorsRegistration() {
        return this.handlerInterceptorsRegistration;
    }

    public static class Builder {
        protected TenantCommandSegmentFactory tenantSegmentFactory;
        protected TargetTenantResolver<CommandMessage<?>> targetTenantResolver;

        public Builder tenantSegmentFactory(TenantCommandSegmentFactory tenantSegmentFactory) {
            BuilderUtils.assertNonNull((Object)tenantSegmentFactory, (String)"The TenantCommandSegmentFactory is a hard requirement");
            this.tenantSegmentFactory = tenantSegmentFactory;
            return this;
        }

        public Builder targetTenantResolver(TargetTenantResolver<CommandMessage<?>> targetTenantResolver) {
            BuilderUtils.assertNonNull(targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
            this.targetTenantResolver = targetTenantResolver;
            return this;
        }

        public MultiTenantCommandBus build() {
            return new MultiTenantCommandBus(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.tenantSegmentFactory, (String)"The TenantCommandSegmentFactory is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement and should be provided");
        }
    }
}

