/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.deadletterqueue;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.multitenancy.TenantWrappedTransactionManager;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterQueueOverflowException;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.NoSuchDeadLetterException;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantDeadLetterQueue<M extends EventMessage<?>>
implements SequencedDeadLetterQueue<M>,
MultiTenantAwareComponent {
    private static final Logger logger = LoggerFactory.getLogger(MultiTenantDeadLetterQueue.class);
    private final Set<TenantDescriptor> tenants = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<TenantDescriptor, SequencedDeadLetterQueue<M>> tenantSegments = new ConcurrentHashMap<TenantDescriptor, SequencedDeadLetterQueue<M>>();
    private final TargetTenantResolver<M> targetTenantResolver;
    private final String processingGroup;
    private Supplier<SequencedDeadLetterQueue<M>> deadLetterQueueSupplier = () -> null;

    protected MultiTenantDeadLetterQueue(Builder<M> builder) {
        builder.validate();
        this.targetTenantResolver = ((Builder)builder).targetTenantResolver;
        this.processingGroup = ((Builder)builder).processingGroup;
    }

    public static <M extends EventMessage<?>> Builder<M> builder() {
        return new Builder();
    }

    public void registerDeadLetterQueueSupplier(Supplier<SequencedDeadLetterQueue<M>> deadLetterQueue) {
        this.deadLetterQueueSupplier = deadLetterQueue;
    }

    public SequencedDeadLetterQueue<M> getTenantSegment(TenantDescriptor tenantDescriptor) {
        return this.tenantSegments.computeIfAbsent(tenantDescriptor, t -> {
            if (this.tenants.contains(tenantDescriptor)) {
                return this.deadLetterQueueSupplier.get();
            }
            return null;
        });
    }

    private SequencedDeadLetterQueue<M> resolveTenant(DeadLetter<? extends M> deadLetter) {
        TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant(deadLetter.message(), this.tenantSegments.keySet());
        SequencedDeadLetterQueue<M> tenantDeadLetterQueue = this.getTenantSegment(tenantDescriptor);
        if (tenantDeadLetterQueue == null) {
            throw new NoSuchTenantException(tenantDescriptor.tenantId());
        }
        return tenantDeadLetterQueue;
    }

    public void enqueue(@Nonnull Object sequenceIdentifier, @Nonnull DeadLetter<? extends M> letter) throws DeadLetterQueueOverflowException {
        this.resolveTenant(letter).enqueue(sequenceIdentifier, letter);
    }

    public boolean enqueueIfPresent(@Nonnull Object sequenceIdentifier, Supplier<DeadLetter<? extends M>> letterBuilder) throws DeadLetterQueueOverflowException {
        return this.resolveTenant(letterBuilder.get()).enqueueIfPresent(sequenceIdentifier, letterBuilder);
    }

    public void evict(DeadLetter<? extends M> letter) {
        this.resolveTenant(letter).evict(letter);
    }

    public void requeue(@Nonnull DeadLetter<? extends M> letter, @Nonnull UnaryOperator<DeadLetter<? extends M>> letterUpdater) throws NoSuchDeadLetterException {
        this.resolveTenant(letter).requeue(letter, letterUpdater);
    }

    public boolean contains(@Nonnull Object sequenceIdentifier) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, seg -> seg.contains(sequenceIdentifier));
        }
        logger.info("No tenant found for current thread. Checking if any tenant contains the sequence identifier.");
        return this.tenants.stream().anyMatch(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.contains(sequenceIdentifier)));
    }

    public Iterable<DeadLetter<? extends M>> deadLetterSequence(@Nonnull Object sequenceIdentifier) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, seg -> seg.deadLetterSequence(sequenceIdentifier));
        }
        logger.info("No tenant found for current thread. Returning all tenants dead letter sequences.");
        return this.tenants.stream().filter(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.contains(sequenceIdentifier))).map(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.deadLetterSequence(sequenceIdentifier))).flatMap(it -> StreamSupport.stream(it.spliterator(), false)).collect(Collectors.toList());
    }

    public Iterable<Iterable<DeadLetter<? extends M>>> deadLetters() {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, SequencedDeadLetterQueue::deadLetters);
        }
        logger.info("No tenant found for current thread. Returning all tenants dead letters.");
        return this.tenants.stream().map(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, SequencedDeadLetterQueue::deadLetters)).flatMap(it -> StreamSupport.stream(it.spliterator(), false)).collect(Collectors.toList());
    }

    public boolean isFull(@Nonnull Object sequenceIdentifier) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, seg -> seg.isFull(sequenceIdentifier));
        }
        logger.info("No tenant found for current thread. Checking if any of the tenants queues is full.");
        return this.tenants.stream().anyMatch(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.isFull(sequenceIdentifier)));
    }

    public long size() {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, SequencedDeadLetterQueue::size);
        }
        logger.info("No tenant found for current thread. Returning total size of all tenants queues.");
        return this.tenants.stream().mapToLong(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, SequencedDeadLetterQueue::size)).sum();
    }

    public long sequenceSize(@Nonnull Object sequenceIdentifier) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, seg -> seg.sequenceSize(sequenceIdentifier));
        }
        logger.info("No tenant found for current thread. Returning total size of sequences.");
        return this.tenants.stream().filter(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.contains(sequenceIdentifier))).findFirst().map(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.sequenceSize(sequenceIdentifier))).orElse(0L);
    }

    public long amountOfSequences() {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, SequencedDeadLetterQueue::amountOfSequences);
        }
        logger.info("No tenant found for current thread. Returning total amount of all sequences from every tenant.");
        return this.tenants.stream().mapToLong(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, SequencedDeadLetterQueue::amountOfSequences)).sum();
    }

    public boolean process(@Nonnull Predicate<DeadLetter<? extends M>> sequenceFilter, @Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, seg -> seg.process(sequenceFilter, processingTask));
        }
        logger.info("No tenant found for current thread. Will process a sequence for all tenants.");
        return this.tenants.stream().map(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.process(sequenceFilter, processingTask))).reduce(false, (a, b) -> a != false || b != false);
    }

    public boolean process(@Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            return this.fetchFromTenantSegment(currentTenant, seg -> seg.process(processingTask));
        }
        logger.info("No tenant found for current thread. Will process a sequence for all tenants.");
        return this.tenants.stream().map(tenant -> this.fetchFromTenantSegment((TenantDescriptor)tenant, seg -> seg.process(processingTask))).reduce(false, (a, b) -> a != false || b != false);
    }

    public void clear() {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            this.executeForTenantSegment(currentTenant, SequencedDeadLetterQueue::clear);
        } else {
            logger.info("No tenant found for current thread. Clearing queues for all tenants.");
            this.tenants.forEach(tenant -> this.executeForTenantSegment((TenantDescriptor)tenant, SequencedDeadLetterQueue::clear));
        }
    }

    private <R> R fetchFromTenantSegment(TenantDescriptor tenantDescriptor, Function<SequencedDeadLetterQueue<M>, R> fetchBlock) {
        return (R)new TenantWrappedTransactionManager(tenantDescriptor).fetchInTransaction(() -> fetchBlock.apply(this.getTenantSegment(tenantDescriptor)));
    }

    private void executeForTenantSegment(TenantDescriptor tenantDescriptor, Consumer<SequencedDeadLetterQueue<M>> executeBlock) {
        new TenantWrappedTransactionManager(tenantDescriptor).fetchInTransaction(() -> {
            executeBlock.accept(this.getTenantSegment(tenantDescriptor));
            return null;
        });
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        this.tenants.add(tenantDescriptor);
        return () -> {
            this.tenants.remove(tenantDescriptor);
            this.tenantSegments.remove(tenantDescriptor);
            return true;
        };
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        return this.registerTenant(tenantDescriptor);
    }

    public String processingGroup() {
        return this.processingGroup;
    }

    public static class Builder<M extends EventMessage<?>> {
        private String processingGroup;
        private TargetTenantResolver<M> targetTenantResolver;

        public Builder<M> targetTenantResolver(TargetTenantResolver<M> targetTenantResolver) {
            BuilderUtils.assertNonNull(targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
            this.targetTenantResolver = targetTenantResolver;
            return this;
        }

        public Builder<M> processingGroup(String processingGroup) {
            this.processingGroup = processingGroup;
            return this;
        }

        public MultiTenantDeadLetterQueue<M> build() {
            return new MultiTenantDeadLetterQueue(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
        }
    }
}

