/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.eventhandeling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.MultiTenantHandlerInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.eventhandeling.TenantEventProcessorSegmentFactory;
import org.axonframework.lifecycle.ShutdownHandler;
import org.axonframework.lifecycle.StartHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;

public class MultiTenantEventProcessor
implements EventProcessor,
MultiTenantAwareComponent,
MultiTenantHandlerInterceptorSupport<EventMessage<?>, EventProcessor> {
    private final Map<TenantDescriptor, EventProcessor> tenantEventProcessorsSegments = new ConcurrentHashMap<TenantDescriptor, EventProcessor>();
    private final List<MessageHandlerInterceptor<? super EventMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> handlerInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final String name;
    private final TenantEventProcessorSegmentFactory tenantEventProcessorSegmentFactory;
    private volatile boolean started = false;

    protected MultiTenantEventProcessor(Builder builder) {
        builder.validate();
        this.name = builder.name;
        this.tenantEventProcessorSegmentFactory = builder.tenantEventProcessorSegmentFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<TenantDescriptor, EventProcessor> tenantSegments() {
        return this.tenantEventProcessorsSegments;
    }

    @Override
    public List<MessageHandlerInterceptor<? super EventMessage<?>>> getHandlerInterceptors() {
        return this.handlerInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getHandlerInterceptorsRegistration() {
        return this.handlerInterceptorsRegistration;
    }

    @StartHandler(phase=0x3FFFFFFF)
    public void start() {
        this.started = true;
        this.tenantEventProcessorsSegments.values().forEach(EventProcessor::start);
    }

    @ShutdownHandler(phase=0x3FFFFFFF)
    public void shutDown() {
        this.started = false;
        this.tenantEventProcessorsSegments.values().forEach(EventProcessor::shutDown);
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isRunning(TenantDescriptor tenantDescriptor) {
        return this.tenantEventProcessorsSegments.get(tenantDescriptor).isRunning();
    }

    public boolean isError() {
        return false;
    }

    public boolean isError(TenantDescriptor tenantDescriptor) {
        return this.tenantEventProcessorsSegments.get(tenantDescriptor).isError();
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        if (this.started) {
            throw new IllegalStateException("Cannot register tenant after processor has been started");
        }
        EventProcessor tenantSegment = (EventProcessor)this.tenantEventProcessorSegmentFactory.apply(tenantDescriptor);
        this.tenantEventProcessorsSegments.putIfAbsent(tenantDescriptor, tenantSegment);
        return () -> this.stopAndRemoveTenant(tenantDescriptor);
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        this.tenantEventProcessorsSegments.computeIfAbsent(tenantDescriptor, tenant -> {
            EventProcessor tenantSegment = (EventProcessor)this.tenantEventProcessorSegmentFactory.apply(tenant);
            this.handlerInterceptors.forEach(handlerInterceptor -> this.handlerInterceptorsRegistration.computeIfAbsent((TenantDescriptor)tenant, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerHandlerInterceptor(handlerInterceptor)));
            tenantSegment.start();
            return tenantSegment;
        });
        return () -> this.stopAndRemoveTenant(tenantDescriptor);
    }

    public boolean stopAndRemoveTenant(TenantDescriptor tenantDescriptor) {
        EventProcessor delegate;
        List<Registration> registrations = this.handlerInterceptorsRegistration.remove(tenantDescriptor);
        if (registrations != null) {
            registrations.forEach(Registration::cancel);
        }
        if ((delegate = this.tenantEventProcessorsSegments.remove(tenantDescriptor)) != null) {
            delegate.shutDown();
            return true;
        }
        return false;
    }

    public List<EventProcessor> tenantEventProcessors() {
        return Collections.unmodifiableList(new ArrayList<EventProcessor>(this.tenantEventProcessorsSegments.values()));
    }

    public static class Builder {
        private String name;
        private TenantEventProcessorSegmentFactory tenantEventProcessorSegmentFactory;

        public Builder name(String name) {
            BuilderUtils.assertNonEmpty((String)name, (String)"A name should be provided");
            this.name = name;
            return this;
        }

        public Builder tenantSegmentFactory(TenantEventProcessorSegmentFactory tenantSegmentFactory) {
            BuilderUtils.assertNonNull((Object)tenantSegmentFactory, (String)"The TenantEventProcessorSegmentFactory should not be null");
            this.tenantEventProcessorSegmentFactory = tenantSegmentFactory;
            return this;
        }

        public MultiTenantEventProcessor build() {
            return new MultiTenantEventProcessor(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty((String)this.name, (String)"The name is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.tenantEventProcessorSegmentFactory, (String)"The TenantEventProcessorSegmentFactory is a hard requirement and should be provided");
        }
    }
}

