/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.eventstore;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.stream.BlockingStream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.MultiStreamableMessageSource;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.MultiTenantDispatchInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.eventstore.MultiTenantSubscribableMessageSource;
import org.axonframework.extensions.multitenancy.components.eventstore.TenantEventSegmentFactory;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class MultiTenantEventStore
implements EventStore,
MultiTenantAwareComponent,
MultiTenantSubscribableMessageSource<EventStore>,
MultiTenantDispatchInterceptorSupport<EventMessage<?>, EventStore> {
    private final Map<TenantDescriptor, EventStore> tenantSegments = new ConcurrentHashMap<TenantDescriptor, EventStore>();
    private final List<Consumer<List<? extends EventMessage<?>>>> messageProcessors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, Registration> subscribeRegistrations = new ConcurrentHashMap<TenantDescriptor, Registration>();
    private final List<MessageDispatchInterceptor<? super EventMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> dispatchInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final TenantEventSegmentFactory tenantSegmentFactory;
    private final TargetTenantResolver<Message<?>> targetTenantResolver;
    private MultiStreamableMessageSource multiSource;

    protected MultiTenantEventStore(Builder builder) {
        builder.validate();
        this.tenantSegmentFactory = builder.tenantSegmentFactory;
        this.targetTenantResolver = builder.targetTenantResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void publish(List<? extends EventMessage<?>> events) {
        events.stream().findFirst().map(this::resolveTenant).orElseGet(this::resolveSegment).publish(events);
    }

    public void publish(EventMessage<?> ... events) {
        Optional.ofNullable(events[0]).map(this::resolveTenant).orElseGet(this::resolveSegment).publish(events);
    }

    public Registration subscribe(@Nonnull Consumer<List<? extends EventMessage<?>>> messageProcessor) {
        this.messageProcessors.add(messageProcessor);
        this.tenantSegments.forEach((tenant, segment) -> this.subscribeRegistrations.putIfAbsent((TenantDescriptor)tenant, segment.subscribe(messageProcessor)));
        return () -> this.subscribeRegistrations.values().stream().map(Registration::cancel).reduce((prev, acc) -> prev != false && acc != false).orElse(false);
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        EventStore tenantSegment = (EventStore)this.tenantSegmentFactory.apply(tenantDescriptor);
        this.tenantSegments.putIfAbsent(tenantDescriptor, tenantSegment);
        return () -> {
            EventStore delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    private EventStore unregisterTenant(TenantDescriptor tenantDescriptor) {
        Registration remove = this.subscribeRegistrations.remove(tenantDescriptor);
        if (remove != null) {
            remove.cancel();
        }
        return this.tenantSegments.remove(tenantDescriptor);
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        this.tenantSegments.computeIfAbsent(tenantDescriptor, k -> {
            EventStore tenantSegment = (EventStore)this.tenantSegmentFactory.apply(tenantDescriptor);
            this.dispatchInterceptors.forEach(dispatchInterceptor -> this.dispatchInterceptorsRegistration.computeIfAbsent(tenantDescriptor, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerDispatchInterceptor(dispatchInterceptor)));
            this.messageProcessors.forEach(processor -> this.subscribeRegistrations.putIfAbsent(tenantDescriptor, tenantSegment.subscribe(processor)));
            return tenantSegment;
        });
        return () -> {
            EventStore delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    private EventStore resolveTenantSilently(Message<?> eventMessage) {
        TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant(eventMessage, this.tenantSegments.keySet());
        return this.tenantSegments.get(tenantDescriptor);
    }

    private EventStore resolveTenant(Message<?> eventMessage) {
        TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant(eventMessage, this.tenantSegments.keySet());
        EventStore tenantEventStore = this.tenantSegments.get(tenantDescriptor);
        if (tenantEventStore == null) {
            throw new NoSuchTenantException(tenantDescriptor.tenantId());
        }
        return tenantEventStore;
    }

    private EventStore resolveSegment() {
        return this.resolveTenantSilently(CurrentUnitOfWork.get().getMessage());
    }

    public DomainEventStream readEvents(@Nonnull String aggregateIdentifier) {
        return this.resolveSegment().readEvents(aggregateIdentifier);
    }

    public DomainEventStream readEvents(@Nonnull String aggregateIdentifier, @Nonnull TenantDescriptor tenantDescriptor) {
        return this.tenantSegments.get(tenantDescriptor).readEvents(aggregateIdentifier);
    }

    public void storeSnapshot(@Nonnull DomainEventMessage<?> snapshot) {
        this.resolveSegment().storeSnapshot(snapshot);
    }

    public void storeSnapshot(DomainEventMessage<?> snapshot, TenantDescriptor tenantDescriptor) {
        this.tenantSegments.get(tenantDescriptor).storeSnapshot(snapshot);
    }

    public BlockingStream<TrackedEventMessage<?>> openStream(TrackingToken trackingToken) {
        return this.multiSource().openStream(trackingToken);
    }

    private MultiStreamableMessageSource multiSource() {
        if (Objects.isNull(this.multiSource)) {
            MultiStreamableMessageSource.Builder sourceBuilder = MultiStreamableMessageSource.builder();
            this.tenantSegments.forEach((key, value) -> sourceBuilder.addMessageSource(key.tenantId(), (StreamableMessageSource)value));
            this.multiSource = sourceBuilder.build();
        }
        return this.multiSource;
    }

    public TrackingToken createTailToken() {
        return this.multiSource().createTailToken();
    }

    public TrackingToken createHeadToken() {
        return this.multiSource().createHeadToken();
    }

    public TrackingToken createTokenAt(Instant dateTime) {
        return this.multiSource().createTokenAt(dateTime);
    }

    public TrackingToken createTokenSince(Duration duration) {
        return this.multiSource().createTokenSince(duration);
    }

    @Override
    public Map<TenantDescriptor, EventStore> tenantSegments() {
        return this.tenantSegments;
    }

    @Override
    public List<MessageDispatchInterceptor<? super EventMessage<?>>> getDispatchInterceptors() {
        return this.dispatchInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getDispatchInterceptorsRegistration() {
        return this.dispatchInterceptorsRegistration;
    }

    public static class Builder {
        protected TenantEventSegmentFactory tenantSegmentFactory;
        protected TargetTenantResolver<Message<?>> targetTenantResolver;

        public Builder tenantSegmentFactory(TenantEventSegmentFactory tenantSegmentFactory) {
            BuilderUtils.assertNonNull((Object)tenantSegmentFactory, (String)"The TenantEventSegmentFactory is a hard requirement");
            this.tenantSegmentFactory = tenantSegmentFactory;
            return this;
        }

        public Builder targetTenantResolver(TargetTenantResolver<Message<?>> targetTenantResolver) {
            BuilderUtils.assertNonNull(targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
            this.targetTenantResolver = targetTenantResolver;
            return this;
        }

        public MultiTenantEventStore build() {
            return new MultiTenantEventStore(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.tenantSegmentFactory, (String)"The TenantEventProcessorSegmentFactory is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement and should be provided");
        }
    }
}

