/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.queryhandeling;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.MultiTenantDispatchInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.MultiTenantHandlerInterceptorSupport;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.queryhandeling.TenantQuerySegmentFactory;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QuerySubscription;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.StreamingQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.reactivestreams.Publisher;

public class MultiTenantQueryBus
implements QueryBus,
MultiTenantAwareComponent,
MultiTenantDispatchInterceptorSupport<QueryMessage<?, ?>, QueryBus>,
MultiTenantHandlerInterceptorSupport<QueryMessage<?, ?>, QueryBus> {
    private final Map<String, QuerySubscription<?>> handlers = new ConcurrentHashMap();
    private final Map<TenantDescriptor, QueryBus> tenantSegments = new ConcurrentHashMap<TenantDescriptor, QueryBus>();
    private final Map<TenantDescriptor, Registration> subscribeRegistrations = new ConcurrentHashMap<TenantDescriptor, Registration>();
    private final List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> dispatchInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final List<MessageHandlerInterceptor<? super QueryMessage<?, ?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final Map<TenantDescriptor, List<Registration>> handlerInterceptorsRegistration = new ConcurrentHashMap<TenantDescriptor, List<Registration>>();
    private final TenantQuerySegmentFactory tenantSegmentFactory;
    private final TargetTenantResolver<QueryMessage<?, ?>> targetTenantResolver;

    protected MultiTenantQueryBus(Builder builder) {
        builder.validate();
        this.tenantSegmentFactory = builder.tenantSegmentFactory;
        this.targetTenantResolver = builder.targetTenantResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(@Nonnull QueryMessage<Q, R> query) {
        QueryBus tenantQueryBus = this.resolveTenant(query);
        return tenantQueryBus.query(query);
    }

    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(@Nonnull QueryMessage<Q, R> query, long timeout, @Nonnull TimeUnit unit) {
        QueryBus tenantQueryBus = this.resolveTenant(query);
        return tenantQueryBus.scatterGather(query, timeout, unit);
    }

    public <Q, R> Publisher<QueryResponseMessage<R>> streamingQuery(StreamingQueryMessage<Q, R> query) {
        QueryBus tenantQueryBus = this.resolveTenant((QueryMessage<?, ?>)query);
        return tenantQueryBus.streamingQuery(query);
    }

    public <R> Registration subscribe(@Nonnull String queryName, @Nonnull Type responseType, @Nonnull MessageHandler<? super QueryMessage<?, R>> handler) {
        this.handlers.computeIfAbsent(queryName, k -> {
            this.tenantSegments.forEach((tenant, segment) -> this.subscribeRegistrations.putIfAbsent((TenantDescriptor)tenant, segment.subscribe(queryName, responseType, handler)));
            return new QuerySubscription(responseType, handler);
        });
        return () -> this.subscribeRegistrations.values().stream().map(Registration::cancel).reduce((prev, acc) -> prev != false && acc != false).orElse(false);
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        QueryBus tenantSegment = (QueryBus)this.tenantSegmentFactory.apply(tenantDescriptor);
        this.tenantSegments.putIfAbsent(tenantDescriptor, tenantSegment);
        return () -> {
            QueryBus delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    private QueryBus unregisterTenant(TenantDescriptor tenantDescriptor) {
        Registration removed;
        List<Registration> registrations = this.handlerInterceptorsRegistration.remove(tenantDescriptor);
        if (registrations != null) {
            registrations.forEach(Registration::cancel);
        }
        if ((registrations = this.dispatchInterceptorsRegistration.remove(tenantDescriptor)) != null) {
            registrations.forEach(Registration::cancel);
        }
        if ((removed = this.subscribeRegistrations.remove(tenantDescriptor)) != null) {
            removed.cancel();
        }
        return this.tenantSegments.remove(tenantDescriptor);
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        this.tenantSegments.computeIfAbsent(tenantDescriptor, tenant -> {
            QueryBus tenantSegment = (QueryBus)this.tenantSegmentFactory.apply(tenant);
            this.dispatchInterceptors.forEach(handlerInterceptor -> this.dispatchInterceptorsRegistration.computeIfAbsent((TenantDescriptor)tenant, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerDispatchInterceptor(handlerInterceptor)));
            this.handlerInterceptors.forEach(handlerInterceptor -> this.handlerInterceptorsRegistration.computeIfAbsent((TenantDescriptor)tenant, t -> new CopyOnWriteArrayList()).add(tenantSegment.registerHandlerInterceptor(handlerInterceptor)));
            this.handlers.forEach((queryName, querySubscription) -> this.subscribeRegistrations.putIfAbsent(tenantDescriptor, tenantSegment.subscribe(queryName, querySubscription.getResponseType(), querySubscription.getQueryHandler())));
            return tenantSegment;
        });
        return () -> {
            QueryBus delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(@Nonnull SubscriptionQueryMessage<Q, I, U> query) {
        return this.resolveTenant((QueryMessage<?, ?>)query).subscriptionQuery(query);
    }

    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(@Nonnull SubscriptionQueryMessage<Q, I, U> query, int updateBufferSize) {
        return this.resolveTenant((QueryMessage<?, ?>)query).subscriptionQuery(query, updateBufferSize);
    }

    private QueryBus resolveTenant(QueryMessage<?, ?> queryMessage) {
        TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant(queryMessage, this.tenantSegments.keySet());
        QueryBus tenantQueryBus = this.tenantSegments.get(tenantDescriptor);
        if (tenantQueryBus == null) {
            throw new NoSuchTenantException(tenantDescriptor.tenantId());
        }
        return tenantQueryBus;
    }

    public QueryUpdateEmitter queryUpdateEmitter() {
        return this.resolveTenant((QueryMessage)CurrentUnitOfWork.get().getMessage()).queryUpdateEmitter();
    }

    public QueryUpdateEmitter queryUpdateEmitter(TenantDescriptor tenantDescriptor) {
        return this.tenantSegments.get(tenantDescriptor).queryUpdateEmitter();
    }

    @Override
    public Map<TenantDescriptor, QueryBus> tenantSegments() {
        return this.tenantSegments;
    }

    @Override
    public List<MessageHandlerInterceptor<? super QueryMessage<?, ?>>> getHandlerInterceptors() {
        return this.handlerInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getHandlerInterceptorsRegistration() {
        return this.handlerInterceptorsRegistration;
    }

    @Override
    public List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> getDispatchInterceptors() {
        return this.dispatchInterceptors;
    }

    @Override
    public Map<TenantDescriptor, List<Registration>> getDispatchInterceptorsRegistration() {
        return this.dispatchInterceptorsRegistration;
    }

    public static class Builder {
        protected TargetTenantResolver<QueryMessage<?, ?>> targetTenantResolver;
        protected TenantQuerySegmentFactory tenantSegmentFactory;

        public Builder tenantSegmentFactory(TenantQuerySegmentFactory tenantSegmentFactory) {
            BuilderUtils.assertNonNull((Object)tenantSegmentFactory, (String)"The TenantQuerySegmentFactory is a hard requirement");
            this.tenantSegmentFactory = tenantSegmentFactory;
            return this;
        }

        public Builder targetTenantResolver(TargetTenantResolver<QueryMessage<?, ?>> targetTenantResolver) {
            BuilderUtils.assertNonNull(targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
            this.targetTenantResolver = targetTenantResolver;
            return this;
        }

        public MultiTenantQueryBus build() {
            return new MultiTenantQueryBus(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.tenantSegmentFactory, (String)"The TenantQuerySegmentFactory is a hard requirement and should be provided");
        }
    }
}

