/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.multitenancy.components.scheduling;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.extensions.multitenancy.TenantWrappedTransactionManager;
import org.axonframework.extensions.multitenancy.components.MultiTenantAwareComponent;
import org.axonframework.extensions.multitenancy.components.NoSuchTenantException;
import org.axonframework.extensions.multitenancy.components.TargetTenantResolver;
import org.axonframework.extensions.multitenancy.components.TenantDescriptor;
import org.axonframework.extensions.multitenancy.components.scheduling.TenantEventSchedulerSegmentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantEventScheduler
implements EventScheduler,
MultiTenantAwareComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TenantEventSchedulerSegmentFactory tenantSegmentFactory;
    private final TargetTenantResolver<EventMessage<?>> targetTenantResolver;
    private final Map<TenantDescriptor, EventScheduler> tenantSegments = new ConcurrentHashMap<TenantDescriptor, EventScheduler>();

    protected MultiTenantEventScheduler(Builder builder) {
        builder.validate();
        this.tenantSegmentFactory = builder.tenantSegmentFactory;
        this.targetTenantResolver = builder.targetTenantResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScheduleToken schedule(Instant instant, Object event) {
        return this.resolveTenant(event).schedule(instant, event);
    }

    public ScheduleToken schedule(Duration duration, Object event) {
        return this.resolveTenant(event).schedule(duration, event);
    }

    public void cancelSchedule(ScheduleToken scheduleToken) {
        TenantDescriptor currentTenant = TenantWrappedTransactionManager.getCurrentTenant();
        if (currentTenant != null) {
            this.tenantSegments.get(currentTenant).cancelSchedule(scheduleToken);
        } else {
            logger.info("No current tenant found. Canceling schedule token {} by searching in all tenants.", (Object)scheduleToken);
            this.tenantSegments.forEach((tenantDescriptor, eventScheduler) -> {
                try {
                    logger.info("Cancelling schedule token {} for tenant {}.", (Object)scheduleToken, (Object)tenantDescriptor.tenantId());
                    eventScheduler.cancelSchedule(scheduleToken);
                }
                catch (IllegalArgumentException e) {
                    logger.info("Schedule token {} does not belong to tenant {}. Skipping cancel task for this tenant.", (Object)scheduleToken, (Object)tenantDescriptor.tenantId());
                }
            });
        }
    }

    public ScheduleToken reschedule(ScheduleToken scheduleToken, Duration triggerDuration, Object event) {
        return this.resolveTenant(event).reschedule(scheduleToken, triggerDuration, event);
    }

    public ScheduleToken reschedule(ScheduleToken scheduleToken, Instant instant, Object event) {
        return this.resolveTenant(event).reschedule(scheduleToken, instant, event);
    }

    public void shutdown() {
        this.tenantSegments.forEach((tenantDescriptor, eventScheduler) -> eventScheduler.shutdown());
    }

    public EventScheduler forTenant(TenantDescriptor tenantDescriptor) {
        return this.tenantSegments.get(tenantDescriptor);
    }

    public Map<TenantDescriptor, EventScheduler> getTenantSegments() {
        return this.tenantSegments;
    }

    @Override
    public Registration registerTenant(TenantDescriptor tenantDescriptor) {
        EventScheduler tenantSegment = (EventScheduler)this.tenantSegmentFactory.apply(tenantDescriptor);
        this.tenantSegments.putIfAbsent(tenantDescriptor, tenantSegment);
        return () -> {
            EventScheduler delegate = this.unregisterTenant(tenantDescriptor);
            return delegate != null;
        };
    }

    private EventScheduler unregisterTenant(TenantDescriptor tenantDescriptor) {
        EventScheduler eventScheduler = this.tenantSegments.remove(tenantDescriptor);
        if (eventScheduler != null) {
            eventScheduler.shutdown();
        }
        return eventScheduler;
    }

    @Override
    public Registration registerAndStartTenant(TenantDescriptor tenantDescriptor) {
        return this.registerTenant(tenantDescriptor);
    }

    private EventScheduler resolveTenant(Object event) {
        if (event instanceof EventMessage) {
            TenantDescriptor tenantDescriptor = this.targetTenantResolver.resolveTenant((EventMessage)event, this.tenantSegments.keySet());
            EventScheduler tenantSegment = this.tenantSegments.get(tenantDescriptor);
            if (tenantSegment == null) {
                throw new NoSuchTenantException(tenantDescriptor.tenantId());
            }
            return tenantSegment;
        }
        throw new IllegalArgumentException("Message is not an instance of EventMessage and doesn't contain Meta Data to resolve the tenant.");
    }

    public static class Builder {
        private TargetTenantResolver<EventMessage<?>> targetTenantResolver;
        private TenantEventSchedulerSegmentFactory tenantSegmentFactory;

        public Builder tenantSegmentFactory(TenantEventSchedulerSegmentFactory tenantSegmentFactory) {
            BuilderUtils.assertNonNull((Object)tenantSegmentFactory, (String)"The TenantEventSchedulerSegmentFactory is a hard requirement");
            this.tenantSegmentFactory = tenantSegmentFactory;
            return this;
        }

        public Builder targetTenantResolver(TargetTenantResolver<EventMessage<?>> targetTenantResolver) {
            BuilderUtils.assertNonNull(targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement");
            this.targetTenantResolver = targetTenantResolver;
            return this;
        }

        public MultiTenantEventScheduler build() {
            return new MultiTenantEventScheduler(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.targetTenantResolver, (String)"The TargetTenantResolver is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.tenantSegmentFactory, (String)"The TenantEventSchedulerSegmentFactory is a hard requirement and should be provided");
        }
    }
}

