/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.springcloud.autoconfig;

import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.DistributedCommandBus;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.config.Configuration;
import org.axonframework.extensions.springcloud.DistributedCommandBusProperties;
import org.axonframework.extensions.springcloud.autoconfig.RoutingStrategyAutoConfiguration;
import org.axonframework.extensions.springcloud.commandhandling.SpringCloudCommandRouter;
import org.axonframework.extensions.springcloud.commandhandling.SpringHttpCommandBusConnector;
import org.axonframework.extensions.springcloud.commandhandling.mode.AcceptAllCommandsDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.CapabilityDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.IgnoreListingDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.MemberCapabilitiesController;
import org.axonframework.extensions.springcloud.commandhandling.mode.RestCapabilityDiscoveryMode;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.autoconfig.InfraConfiguration;
import org.axonframework.tracing.SpanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@AutoConfigureAfter(value={RoutingStrategyAutoConfiguration.class, SimpleDiscoveryClientAutoConfiguration.class})
@AutoConfigureBefore(value={InfraConfiguration.class})
@EnableConfigurationProperties(value={DistributedCommandBusProperties.class})
@ConditionalOnProperty(value={"axon.distributed.enabled"})
@ConditionalOnClass(name={"org.axonframework.extensions.springcloud.commandhandling.SpringCloudCommandRouter", "org.axonframework.extensions.springcloud.commandhandling.SpringHttpCommandBusConnector", "org.springframework.cloud.client.discovery.DiscoveryClient", "org.springframework.web.client.RestTemplate"})
public class SpringCloudAutoConfiguration {
    private final DistributedCommandBusProperties properties;
    private final DistributedCommandBusProperties.SpringCloudProperties springCloudProperties;

    public SpringCloudAutoConfiguration(DistributedCommandBusProperties properties) {
        this.properties = properties;
        this.springCloudProperties = properties.getSpringCloud();
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"axon.distributed.spring-cloud.mode"}, havingValue="REST", matchIfMissing=true)
    public RestCapabilityDiscoveryMode restCapabilityDiscoveryMode(Serializer serializer, RestTemplate restTemplate) {
        return RestCapabilityDiscoveryMode.builder().serializer(serializer).restTemplate(restTemplate).messageCapabilitiesEndpoint(this.springCloudProperties.getRestModeUrl()).build();
    }

    @Bean
    @ConditionalOnBean(value={RestCapabilityDiscoveryMode.class})
    @ConditionalOnMissingBean(value={MemberCapabilitiesController.class})
    public MemberCapabilitiesController memberCapabilitiesController(RestCapabilityDiscoveryMode restCapabilityDiscoveryMode) {
        return MemberCapabilitiesController.builder().restCapabilityDiscoveryMode(restCapabilityDiscoveryMode).build();
    }

    @Primary
    @Bean(value={"capabilityDiscoveryMode"})
    @ConditionalOnExpression(value="${axon.distributed.spring-cloud.enable-ignore-listing:true} or ${axon.distributed.spring-cloud.enable-accept-all-commands:false}")
    public CapabilityDiscoveryMode decorateCapabilityDiscoveryMode(CapabilityDiscoveryMode capabilityDiscoveryMode) {
        CapabilityDiscoveryMode decoratedDiscoveryMode = capabilityDiscoveryMode;
        if (this.springCloudProperties.shouldEnableAcceptAllCommands()) {
            decoratedDiscoveryMode = AcceptAllCommandsDiscoveryMode.builder().delegate(decoratedDiscoveryMode).build();
        }
        if (this.springCloudProperties.shouldEnabledIgnoreListing()) {
            decoratedDiscoveryMode = IgnoreListingDiscoveryMode.builder().delegate(decoratedDiscoveryMode).build();
        }
        return decoratedDiscoveryMode;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DiscoveryClient.class})
    public CommandRouter springCloudCommandRouter(DiscoveryClient discoveryClient, Registration localServiceInstance, RoutingStrategy routingStrategy, CapabilityDiscoveryMode capabilityDiscoveryMode, Serializer serializer) {
        return SpringCloudCommandRouter.builder().discoveryClient(discoveryClient).localServiceInstance(localServiceInstance).routingStrategy(routingStrategy).capabilityDiscoveryMode(capabilityDiscoveryMode).serializer(serializer).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandBusConnector.class})
    public CommandBusConnector springHttpCommandBusConnector(@Qualifier(value="localSegment") CommandBus localSegment, RestTemplate restTemplate, @Qualifier(value="messageSerializer") Serializer serializer, SpanFactory spanFactory) {
        return SpringHttpCommandBusConnector.builder().localCommandBus(localSegment).restOperations((RestOperations)restTemplate).serializer(serializer).spanFactory(spanFactory).build();
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={CommandBusConnector.class})
    @ConditionalOnMissingBean
    public DistributedCommandBus distributedCommandBus(CommandRouter commandRouter, CommandBusConnector commandBusConnector, Configuration configuration, SpanFactory spanFactory) {
        DistributedCommandBus commandBus = DistributedCommandBus.builder().commandRouter(commandRouter).connector(commandBusConnector).messageMonitor(configuration.messageMonitor(DistributedCommandBus.class, "commandBus")).spanFactory(spanFactory).build();
        commandBus.updateLoadFactor(this.properties.getLoadFactor());
        return commandBus;
    }
}

