/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.springcloud.commandhandling;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.ConsistentHash;
import org.axonframework.commandhandling.distributed.ConsistentHashChangeListener;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.commandhandling.distributed.SimpleMember;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.springcloud.commandhandling.mode.CapabilityDiscoveryMode;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.event.EventListener;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringCloudCommandRouter
implements CommandRouter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LOAD_FACTOR = "loadFactor";
    private static final String SERIALIZED_COMMAND_FILTER = "serializedCommandFilter";
    private static final String SERIALIZED_COMMAND_FILTER_CLASS_NAME = "serializedCommandFilterClassName";
    private final DiscoveryClient discoveryClient;
    private final Registration localServiceInstance;
    private final RoutingStrategy routingStrategy;
    private final CapabilityDiscoveryMode capabilityDiscoveryMode;
    protected final Serializer serializer;
    private final Predicate<ServiceInstance> serviceInstanceFilter;
    private final ConsistentHashChangeListener consistentHashChangeListener;
    private final String contextRootMetadataPropertyName;
    private final AtomicReference<ConsistentHash> atomicConsistentHash = new AtomicReference<ConsistentHash>(new ConsistentHash());
    private volatile boolean registered = false;

    public static Builder builder() {
        return new Builder();
    }

    protected SpringCloudCommandRouter(Builder builder) {
        builder.validate();
        this.discoveryClient = builder.discoveryClient;
        this.localServiceInstance = builder.localServiceInstance;
        this.routingStrategy = builder.routingStrategy;
        this.capabilityDiscoveryMode = builder.capabilityDiscoveryMode;
        this.serializer = builder.serializerSupplier.get();
        this.serviceInstanceFilter = builder.serviceInstanceFilter;
        this.consistentHashChangeListener = builder.consistentHashChangeListener;
        this.contextRootMetadataPropertyName = builder.contextRootMetadataPropertyName;
    }

    @Deprecated
    public static boolean serviceInstanceMetadataContainsMessageRoutingInformation(ServiceInstance serviceInstance) {
        Map serviceInstanceMetadata = serviceInstance.getMetadata();
        return serviceInstanceMetadata != null && serviceInstanceMetadata.containsKey(LOAD_FACTOR) && serviceInstanceMetadata.containsKey(SERIALIZED_COMMAND_FILTER) && serviceInstanceMetadata.containsKey(SERIALIZED_COMMAND_FILTER_CLASS_NAME);
    }

    public Optional<Member> findDestination(CommandMessage<?> commandMessage) {
        return this.atomicConsistentHash.get().getMember(this.routingStrategy.getRoutingKey(commandMessage), commandMessage);
    }

    public void updateMembership(int loadFactor, CommandMessageFilter commandFilter) {
        this.capabilityDiscoveryMode.updateLocalCapabilities((ServiceInstance)this.localServiceInstance, loadFactor, commandFilter);
        this.consistentHashChangeListener.onConsistentHashChanged(this.atomicConsistentHash.updateAndGet(consistentHash -> consistentHash.with(this.buildMember((ServiceInstance)this.localServiceInstance), loadFactor, commandFilter)));
    }

    @EventListener
    public void resetLocalMembership(InstanceRegisteredEvent<?> event) {
        this.registered = true;
        Optional<Member> startUpPhaseLocalMember = this.atomicConsistentHash.get().getMembers().stream().filter(Member::local).findFirst();
        this.updateMemberships();
        startUpPhaseLocalMember.ifPresent(localMember -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Resetting local membership for [{}].", localMember);
            }
            this.atomicConsistentHash.updateAndGet(consistentHash -> consistentHash.without(localMember));
        });
    }

    @EventListener
    public void updateMemberships(HeartbeatEvent event) {
        this.updateMemberships();
    }

    private void updateMemberships() {
        AtomicReference<ConsistentHash> updatedConsistentHash = new AtomicReference<ConsistentHash>(new ConsistentHash());
        List instances = this.discoveryClient.getServices().stream().map(arg_0 -> ((DiscoveryClient)this.discoveryClient).getInstances(arg_0)).flatMap(Collection::stream).filter(this.serviceInstanceFilter).collect(Collectors.toList());
        if (instances.isEmpty()) {
            instances.add(this.localServiceInstance);
        }
        for (ServiceInstance serviceInstance : instances) {
            logger.debug("Updating membership for service instance: [{}]", (Object)serviceInstance);
            this.capabilityDiscoveryMode.capabilities(serviceInstance).ifPresent(memberCapabilities -> {
                ConsistentHash cfr_ignored_0 = (ConsistentHash)updatedConsistentHash.updateAndGet(consistentHash -> consistentHash.with(this.buildMember(serviceInstance), memberCapabilities.getLoadFactor(), memberCapabilities.getCommandFilter()));
            });
        }
        ConsistentHash newConsistentHash = updatedConsistentHash.get();
        this.atomicConsistentHash.set(newConsistentHash);
        this.consistentHashChangeListener.onConsistentHashChanged(newConsistentHash);
    }

    protected Member buildMember(ServiceInstance serviceInstance) {
        return this.isLocalServiceInstance(serviceInstance) ? this.buildLocalMember(serviceInstance) : this.buildRemoteMember(serviceInstance);
    }

    private boolean isLocalServiceInstance(ServiceInstance serviceInstance) {
        return serviceInstance.equals(this.localServiceInstance) || Objects.equals(serviceInstance.getUri(), this.localServiceInstance.getUri());
    }

    private Member buildLocalMember(ServiceInstance localServiceInstance) {
        String localServiceId = localServiceInstance.getServiceId();
        Object emptyEndpoint = null;
        return this.registered ? new SimpleMember(this.buildName(localServiceId, this.buildRemoteUriWithContextRoot(localServiceInstance)), (Object)localServiceInstance.getUri(), SimpleMember.LOCAL_MEMBER.booleanValue(), this::suspect) : new SimpleMember(localServiceId.toUpperCase() + "[LOCAL]", emptyEndpoint, SimpleMember.LOCAL_MEMBER.booleanValue(), this::suspect);
    }

    private Member buildRemoteMember(ServiceInstance remoteServiceInstance) {
        URI serviceWithContextRootUri = this.buildRemoteUriWithContextRoot(remoteServiceInstance);
        return new SimpleMember(this.buildName(remoteServiceInstance.getServiceId(), serviceWithContextRootUri), (Object)serviceWithContextRootUri, SimpleMember.REMOTE_MEMBER.booleanValue(), this::suspect);
    }

    private String buildName(String serviceId, URI serviceUri) {
        return serviceId.toUpperCase() + "[" + serviceUri + "]";
    }

    private URI buildRemoteUriWithContextRoot(ServiceInstance serviceInstance) {
        if (this.contextRootMetadataPropertyName == null) {
            return serviceInstance.getUri();
        }
        if (serviceInstance.getMetadata() == null) {
            logger.warn("A contextRootMetadataPropertyName [{}] has been provided, but the metadata is null. Defaulting to '/' as the context root.", (Object)this.contextRootMetadataPropertyName);
            return serviceInstance.getUri();
        }
        if (!serviceInstance.getMetadata().containsKey(this.contextRootMetadataPropertyName)) {
            logger.info("The service instance metadata does not contain a property with name '{}'. Defaulting to '/' as the context root.", (Object)this.contextRootMetadataPropertyName);
            return serviceInstance.getUri();
        }
        return UriComponentsBuilder.fromUri((URI)serviceInstance.getUri()).path((String)serviceInstance.getMetadata().get(this.contextRootMetadataPropertyName)).build().toUri();
    }

    private ConsistentHash suspect(Member member) {
        ConsistentHash newConsistentHash = this.atomicConsistentHash.updateAndGet(consistentHash -> consistentHash.without(member));
        this.consistentHashChangeListener.onConsistentHashChanged(newConsistentHash);
        return newConsistentHash;
    }

    public static class Builder {
        private DiscoveryClient discoveryClient;
        private Registration localServiceInstance;
        private RoutingStrategy routingStrategy;
        private CapabilityDiscoveryMode capabilityDiscoveryMode;
        protected Supplier<Serializer> serializerSupplier = XStreamSerializer::defaultSerializer;
        private Predicate<ServiceInstance> serviceInstanceFilter = serviceInstance -> true;
        private ConsistentHashChangeListener consistentHashChangeListener = ConsistentHashChangeListener.noOp();
        private String contextRootMetadataPropertyName;

        public Builder discoveryClient(DiscoveryClient discoveryClient) {
            BuilderUtils.assertNonNull((Object)discoveryClient, (String)"DiscoveryClient may not be null");
            this.discoveryClient = discoveryClient;
            return this;
        }

        public Builder localServiceInstance(Registration localServiceInstance) {
            BuilderUtils.assertNonNull((Object)localServiceInstance, (String)"Registration may not be null");
            this.localServiceInstance = localServiceInstance;
            return this;
        }

        public Builder routingStrategy(RoutingStrategy routingStrategy) {
            BuilderUtils.assertNonNull((Object)routingStrategy, (String)"RoutingStrategy may not be null");
            this.routingStrategy = routingStrategy;
            return this;
        }

        public Builder capabilityDiscoveryMode(CapabilityDiscoveryMode capabilityDiscoveryMode) {
            BuilderUtils.assertNonNull((Object)capabilityDiscoveryMode, (String)"CapabilityDiscoveryMode may not be null");
            this.capabilityDiscoveryMode = capabilityDiscoveryMode;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializerSupplier = () -> serializer;
            return this;
        }

        public Builder serviceInstanceFilter(Predicate<ServiceInstance> serviceInstanceFilter) {
            BuilderUtils.assertNonNull(serviceInstanceFilter, (String)"ServiceInstanceFilter may not be null");
            this.serviceInstanceFilter = serviceInstanceFilter;
            return this;
        }

        public Builder consistentHashChangeListener(ConsistentHashChangeListener consistentHashChangeListener) {
            BuilderUtils.assertNonNull((Object)consistentHashChangeListener, (String)"ConsistentHashChangeListener may not be null");
            this.consistentHashChangeListener = consistentHashChangeListener;
            return this;
        }

        public Builder contextRootMetadataPropertyName(String contextRootMetadataPropertyName) {
            this.contextRootMetadataPropertyName = contextRootMetadataPropertyName;
            return this;
        }

        public SpringCloudCommandRouter build() {
            return new SpringCloudCommandRouter(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.discoveryClient, (String)"The DiscoveryClient is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.localServiceInstance, (String)"The Registration is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.routingStrategy, (String)"The RoutingStrategy is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.capabilityDiscoveryMode, (String)"The CapabilityDiscoveryMode is a hard requirement and should be provided");
        }
    }
}

