/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.springcloud.commandhandling;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.Registration;
import org.axonframework.extensions.springcloud.commandhandling.SpringHttpDispatchMessage;
import org.axonframework.extensions.springcloud.commandhandling.SpringHttpReplyMessage;
import org.axonframework.lifecycle.ShutdownLatch;
import org.axonframework.lifecycle.StartHandler;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestOperations;

@RestController
@RequestMapping(value={"/spring-command-bus-connector"})
public class SpringHttpCommandBusConnector
implements CommandBusConnector {
    private static final Logger logger = LoggerFactory.getLogger(SpringHttpCommandBusConnector.class);
    private static final boolean EXPECT_REPLY = true;
    private static final boolean DO_NOT_EXPECT_REPLY = false;
    private static final String COMMAND_BUS_CONNECTOR_PATH = "/spring-command-bus-connector/command";
    private final CommandBus localCommandBus;
    private final RestOperations restOperations;
    private final Serializer serializer;
    private final Executor executor;
    private final SpanFactory spanFactory;
    private final ShutdownLatch shutdownLatch = new ShutdownLatch();

    protected SpringHttpCommandBusConnector(Builder builder) {
        builder.validate();
        this.localCommandBus = builder.localCommandBus;
        this.restOperations = builder.restOperations;
        this.serializer = builder.serializer;
        this.executor = builder.executor;
        this.spanFactory = builder.spanFactory;
    }

    @StartHandler(phase=-134217728)
    public void start() {
        this.shutdownLatch.initialize();
    }

    public static Builder builder() {
        return new Builder();
    }

    public <C> void send(Member destination, @Nonnull CommandMessage<? extends C> commandMessage) {
        this.shutdownLatch.ifShuttingDown("JGroupsConnector is shutting down, no new commands will be sent.");
        if (destination.local()) {
            this.localCommandBus.dispatch(commandMessage);
        } else {
            this.executor.execute(() -> this.sendRemotely(destination, commandMessage, false));
        }
    }

    public <C, R> void send(Member destination, @Nonnull CommandMessage<C> commandMessage, @Nonnull CommandCallback<? super C, R> callback) {
        this.shutdownLatch.ifShuttingDown("SpringHttpCommandBusConnector is shutting down, no new commands will be sent.");
        ShutdownLatch.ActivityHandle activityHandle = this.shutdownLatch.registerActivity();
        if (destination.local()) {
            CommandCallback wrapper = (cm, crm) -> {
                try {
                    callback.onResult(cm, crm);
                }
                finally {
                    activityHandle.end();
                }
            };
            this.localCommandBus.dispatch(commandMessage, wrapper);
        } else {
            this.executor.execute(() -> {
                try {
                    SpringHttpReplyMessage replyMessage = (SpringHttpReplyMessage)this.sendRemotely(destination, commandMessage, true).getBody();
                    if (replyMessage != null) {
                        callback.onResult(commandMessage, replyMessage.getCommandResultMessage(this.serializer));
                    }
                }
                catch (Exception e) {
                    callback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)new CommandDispatchException("An exception occurred while dispatching a command or its result", (Throwable)e)));
                }
                finally {
                    activityHandle.end();
                }
            });
        }
    }

    public CompletableFuture<Void> initiateShutdown() {
        return this.shutdownLatch.initiateShutdown();
    }

    private <C, R> ResponseEntity<SpringHttpReplyMessage<R>> sendRemotely(Member destination, CommandMessage<? extends C> commandMessage, boolean expectReply) {
        Optional optionalEndpoint = destination.getConnectionEndpoint(URI.class);
        if (optionalEndpoint.isPresent()) {
            URI endpointUri = (URI)optionalEndpoint.get();
            URI destinationUri = this.buildURIForPath(endpointUri.getScheme(), endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), endpointUri.getPath());
            SpringHttpDispatchMessage dispatchMessage = new SpringHttpDispatchMessage(commandMessage, this.serializer, expectReply);
            return this.restOperations.exchange(destinationUri, HttpMethod.POST, new HttpEntity(dispatchMessage), new ParameterizedTypeReference<SpringHttpReplyMessage<R>>(){});
        }
        String errorMessage = String.format("No Connection Endpoint found in Member [%s] for protocol [%s] to send the command message [%s] to", destination, URI.class, commandMessage);
        logger.error(errorMessage);
        throw new IllegalArgumentException(errorMessage);
    }

    private URI buildURIForPath(String scheme, String userInfo, String host, int port, String path) {
        try {
            return new URI(scheme, userInfo, host, port, path + COMMAND_BUS_CONNECTOR_PATH, null, null);
        }
        catch (URISyntaxException e) {
            logger.error("Failed to build URI for [{}{}{}], with user info [{}] and path [{}]", new Object[]{scheme, host, port, userInfo, COMMAND_BUS_CONNECTOR_PATH, e});
            throw new IllegalArgumentException(e);
        }
    }

    public Registration subscribe(@Nonnull String commandName, @Nonnull MessageHandler<? super CommandMessage<?>> handler) {
        return this.localCommandBus.subscribe(commandName, handler);
    }

    public Optional<CommandBus> localSegment() {
        return Optional.of(this.localCommandBus);
    }

    @PostMapping(value={"/command"})
    public <C, R> CompletableFuture<?> receiveCommand(@RequestBody SpringHttpDispatchMessage<C> dispatchMessage) {
        CommandMessage commandMessage;
        try {
            commandMessage = dispatchMessage.getCommandMessage(this.serializer);
        }
        catch (Exception e) {
            logger.error("Could not dispatch command", (Throwable)e);
            return dispatchMessage.isExpectReply() ? CompletableFuture.completedFuture(this.createReply("UNKNOWN", GenericCommandResultMessage.asCommandResultMessage((Throwable)e))) : SpringHttpCommandBusConnector.exceptionallyCompleted(e);
        }
        Span span = this.spanFactory.createChildHandlerSpan(() -> "SpringHttpCommandBusConnector.handle", commandMessage, new Message[0]);
        return (CompletableFuture)span.runSupplier(() -> {
            if (dispatchMessage.isExpectReply()) {
                try {
                    SpringHttpReplyFutureCallback replyFutureCallback = new SpringHttpReplyFutureCallback();
                    this.localCommandBus.dispatch(commandMessage, replyFutureCallback);
                    return replyFutureCallback;
                }
                catch (Exception e) {
                    logger.error("Could not dispatch command", (Throwable)e);
                    span.recordException((Throwable)e);
                    return CompletableFuture.completedFuture(this.createReply(commandMessage.getIdentifier(), GenericCommandResultMessage.asCommandResultMessage((Throwable)e)));
                }
            }
            try {
                this.localCommandBus.dispatch(commandMessage);
                return CompletableFuture.completedFuture("");
            }
            catch (Exception e) {
                logger.error("Could not dispatch command", (Throwable)e);
                span.recordException((Throwable)e);
                return CompletableFuture.completedFuture(this.createReply(commandMessage.getIdentifier(), GenericCommandResultMessage.asCommandResultMessage((Throwable)e)));
            }
        });
    }

    private SpringHttpReplyMessage<?> createReply(String commandIdentifier, CommandResultMessage<?> commandResultMessage) {
        try {
            return new SpringHttpReplyMessage(commandIdentifier, commandResultMessage, this.serializer);
        }
        catch (Exception e) {
            logger.warn("Could not serialize command reply [{}]. Sending back NULL.", commandResultMessage, (Object)e);
            return new SpringHttpReplyMessage(commandIdentifier, GenericCommandResultMessage.asCommandResultMessage((Throwable)e), this.serializer);
        }
    }

    private static CompletableFuture<Object> exceptionallyCompleted(Exception e) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        result.completeExceptionally(e);
        return result;
    }

    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.localCommandBus.registerHandlerInterceptor(handlerInterceptor);
    }

    public static class Builder {
        private CommandBus localCommandBus;
        private RestOperations restOperations;
        private Serializer serializer;
        private Executor executor = DirectExecutor.INSTANCE;
        private SpanFactory spanFactory = NoOpSpanFactory.INSTANCE;

        public Builder localCommandBus(CommandBus localCommandBus) {
            BuilderUtils.assertNonNull((Object)localCommandBus, (String)"Local CommandBus may not be null");
            this.localCommandBus = localCommandBus;
            return this;
        }

        public Builder restOperations(RestOperations restOperations) {
            BuilderUtils.assertNonNull((Object)restOperations, (String)"RestOperations may not be null");
            this.restOperations = restOperations;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder executor(Executor executor) {
            BuilderUtils.assertNonNull((Object)executor, (String)"Executor may not be null");
            this.executor = executor;
            return this;
        }

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public SpringHttpCommandBusConnector build() {
            return new SpringHttpCommandBusConnector(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.localCommandBus, (String)"The local CommandBus is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.restOperations, (String)"The RestOperations is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.serializer, (String)"The Serializer is a hard requirement and should be provided");
        }
    }

    public class SpringHttpReplyFutureCallback<C, R>
    extends CompletableFuture<SpringHttpReplyMessage<?>>
    implements CommandCallback<C, R> {
        public void onResult(CommandMessage<? extends C> commandMessage, @Nonnull CommandResultMessage<? extends R> commandResultMessage) {
            super.complete(SpringHttpCommandBusConnector.this.createReply(commandMessage.getIdentifier(), commandResultMessage));
        }
    }
}

