/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.springcloud.commandhandling.mode;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.extensions.springcloud.commandhandling.mode.CapabilityDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.DefaultMemberCapabilities;
import org.axonframework.extensions.springcloud.commandhandling.mode.MemberCapabilities;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public abstract class AbstractCapabilityDiscoveryMode<B extends CapabilityDiscoveryMode>
implements CapabilityDiscoveryMode {
    protected AtomicReference<ServiceInstance> localInstance;
    protected AtomicReference<MemberCapabilities> localCapabilities;

    protected AbstractCapabilityDiscoveryMode(Builder<B> builder) {
        builder.validate();
        this.localInstance = new AtomicReference<ServiceInstance>(FixedURIServiceInstance.INSTANCE);
        this.localCapabilities = new AtomicReference<MemberCapabilities>(DefaultMemberCapabilities.INCAPABLE_MEMBER);
    }

    @Override
    public void updateLocalCapabilities(ServiceInstance localInstance, int loadFactor, CommandMessageFilter commandFilter) {
        this.localInstance.getAndUpdate(old -> localInstance);
        this.localCapabilities.getAndUpdate(old -> new DefaultMemberCapabilities(loadFactor, commandFilter));
    }

    private static class FixedURIServiceInstance
    extends DefaultServiceInstance {
        private static final ServiceInstance INSTANCE = new FixedURIServiceInstance();
        private static final URI FIXED_URI = URI.create("");

        private FixedURIServiceInstance() {
        }

        public URI getUri() {
            return FIXED_URI;
        }
    }

    protected static abstract class Builder<B extends CapabilityDiscoveryMode> {
        protected Builder() {
        }

        public abstract B build();

        protected abstract void validate();
    }
}

