/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.springcloud.commandhandling.mode;

import java.lang.invoke.MethodHandles;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.springcloud.commandhandling.mode.AbstractCapabilityDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.CapabilityDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.MemberCapabilities;
import org.axonframework.extensions.springcloud.commandhandling.mode.ServiceInstanceClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class IgnoreListingDiscoveryMode
extends AbstractCapabilityDiscoveryMode<IgnoreListingDiscoveryMode> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static Clock clock = Clock.systemUTC();
    private final CapabilityDiscoveryMode delegate;
    private final Duration expireThreshold;
    private final Map<ServiceInstance, Long> ignoredServices = new HashMap<ServiceInstance, Long>();

    public static Builder builder() {
        return new Builder();
    }

    protected IgnoreListingDiscoveryMode(Builder builder) {
        super(builder);
        this.delegate = builder.delegate;
        this.expireThreshold = builder.expireThreshold;
    }

    @Override
    public void updateLocalCapabilities(ServiceInstance localInstance, int loadFactor, CommandMessageFilter commandFilter) {
        this.delegate.updateLocalCapabilities(localInstance, loadFactor, commandFilter);
    }

    @Override
    public Optional<MemberCapabilities> capabilities(ServiceInstance serviceInstance) throws ServiceInstanceClientException {
        if (this.shouldIgnore(serviceInstance)) {
            return Optional.empty();
        }
        try {
            return this.delegate.capabilities(serviceInstance);
        }
        catch (ServiceInstanceClientException e) {
            long expiryTime = clock.instant().toEpochMilli() + this.expireThreshold.toMillis();
            this.ignoredServices.put(serviceInstance, expiryTime);
            logger.info("Added ServiceInstance [{}] under host [{}] and port [{}] to the denied list, since we could not retrieve the required member capabilities from it.", new Object[]{serviceInstance.getServiceId(), serviceInstance.getHost(), serviceInstance.getPort(), e});
            return Optional.empty();
        }
    }

    private boolean shouldIgnore(ServiceInstance service) {
        long currentTime = clock.instant().toEpochMilli();
        boolean shouldIgnore = false;
        HashSet<ServiceInstance> expiredInstances = new HashSet<ServiceInstance>();
        for (Map.Entry<ServiceInstance, Long> instance : this.ignoredServices.entrySet()) {
            if (this.equals(instance.getKey(), service)) {
                shouldIgnore = true;
            }
            if (instance.getValue() > currentTime) continue;
            expiredInstances.add(instance.getKey());
        }
        expiredInstances.forEach(this.ignoredServices::remove);
        return shouldIgnore;
    }

    private boolean equals(ServiceInstance serviceInstance, ServiceInstance ignoredInstance) {
        if (serviceInstance == ignoredInstance) {
            return true;
        }
        if (ignoredInstance == null) {
            return false;
        }
        return Objects.equals(serviceInstance.getServiceId(), ignoredInstance.getServiceId()) && Objects.equals(serviceInstance.getHost(), ignoredInstance.getHost()) && Objects.equals(serviceInstance.getPort(), ignoredInstance.getPort());
    }

    public static class Builder
    extends AbstractCapabilityDiscoveryMode.Builder<IgnoreListingDiscoveryMode> {
        private CapabilityDiscoveryMode delegate;
        private Duration expireThreshold = Duration.ofMinutes(1L);

        public Builder delegate(CapabilityDiscoveryMode delegate) {
            BuilderUtils.assertNonNull((Object)delegate, (String)"The delegate CapabilityDiscovery may not be null or empty");
            this.delegate = delegate;
            return this;
        }

        public Builder expireThreshold(Duration expireThreshold) {
            BuilderUtils.assertThat((Object)expireThreshold, threshold -> threshold != null && !threshold.isNegative() && !threshold.isZero(), (String)"The expire threshold should be strictly positive");
            this.expireThreshold = expireThreshold;
            return this;
        }

        @Override
        public IgnoreListingDiscoveryMode build() {
            return new IgnoreListingDiscoveryMode(this);
        }

        @Override
        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.delegate, (String)"The delegate CapabilityDiscoveryMode is a hard requirement and should be provided");
        }
    }
}

