/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.springcloud.commandhandling.mode;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.springcloud.commandhandling.mode.AbstractCapabilityDiscoveryMode;
import org.axonframework.extensions.springcloud.commandhandling.mode.DefaultMemberCapabilities;
import org.axonframework.extensions.springcloud.commandhandling.mode.MemberCapabilities;
import org.axonframework.extensions.springcloud.commandhandling.mode.SerializedMemberCapabilities;
import org.axonframework.extensions.springcloud.commandhandling.mode.ServiceInstanceClientException;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestCapabilityDiscoveryMode
extends AbstractCapabilityDiscoveryMode<RestCapabilityDiscoveryMode> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Serializer serializer;
    private final RestTemplate restTemplate;
    private final String memberCapabilitiesEndpoint;

    public static Builder builder() {
        return new Builder();
    }

    protected RestCapabilityDiscoveryMode(Builder builder) {
        super(builder);
        this.serializer = (Serializer)builder.serializerSupplier.get();
        this.restTemplate = builder.restTemplate;
        this.memberCapabilitiesEndpoint = builder.messageCapabilitiesEndpoint;
    }

    @Override
    public Optional<MemberCapabilities> capabilities(ServiceInstance serviceInstance) {
        try {
            return Optional.of(this.requestMessageRoutingInformation(serviceInstance));
        }
        catch (HttpClientErrorException e) {
            throw new ServiceInstanceClientException("Failed to retrieve the member's capabilities due to a client specific exception.", e);
        }
        catch (Exception e) {
            logger.info("Failed to receive the capabilities from ServiceInstance [{}] under host [{}] and port [{}]. Will temporarily set this instance to deny all incoming messages.", new Object[]{serviceInstance.getServiceId(), serviceInstance.getHost(), serviceInstance.getPort()});
            logger.debug("Service Instance [{}] is denying all messages due to the following exception: ", (Object)serviceInstance, (Object)e);
            return Optional.of(DefaultMemberCapabilities.INCAPABLE_MEMBER);
        }
    }

    private MemberCapabilities requestMessageRoutingInformation(ServiceInstance serviceInstance) {
        if (this.isLocalServiceInstance(serviceInstance)) {
            return (MemberCapabilities)this.localCapabilities.get();
        }
        URI destinationUri = UriComponentsBuilder.fromUri((URI)serviceInstance.getUri()).path(this.memberCapabilitiesEndpoint).build().toUri();
        SerializedMemberCapabilities serializedMemberCapabilities = (SerializedMemberCapabilities)this.restTemplate.exchange(destinationUri, HttpMethod.GET, HttpEntity.EMPTY, SerializedMemberCapabilities.class).getBody();
        return new DefaultMemberCapabilities(serializedMemberCapabilities, this.serializer);
    }

    private boolean isLocalServiceInstance(ServiceInstance serviceInstance) {
        return Objects.equals(serviceInstance, this.localInstance.get()) || Objects.equals(serviceInstance.getUri(), ((ServiceInstance)this.localInstance.get()).getUri());
    }

    public SerializedMemberCapabilities getLocalMemberCapabilities() {
        return SerializedMemberCapabilities.build((MemberCapabilities)this.localCapabilities.get(), this.serializer);
    }

    public static class Builder
    extends AbstractCapabilityDiscoveryMode.Builder<RestCapabilityDiscoveryMode> {
        private Supplier<Serializer> serializerSupplier = XStreamSerializer::defaultSerializer;
        private RestTemplate restTemplate;
        private String messageCapabilitiesEndpoint = "/member-capabilities";

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializerSupplier = () -> serializer;
            return this;
        }

        public Builder restTemplate(RestTemplate restTemplate) {
            BuilderUtils.assertNonNull((Object)restTemplate, (String)"RestTemplate may not be null");
            this.restTemplate = restTemplate;
            return this;
        }

        public Builder messageCapabilitiesEndpoint(String messageCapabilitiesEndpoint) {
            BuilderUtils.assertNonEmpty((String)messageCapabilitiesEndpoint, (String)"The messageCapabilitiesEndpoint may not be null or empty");
            this.messageCapabilitiesEndpoint = messageCapabilitiesEndpoint;
            return this;
        }

        @Override
        public RestCapabilityDiscoveryMode build() {
            return new RestCapabilityDiscoveryMode(this);
        }

        @Override
        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.restTemplate, (String)"The RestTemplate is a hard requirement and should be provided");
        }
    }
}

