/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing.autoconfig;

import io.opentracing.Tracer;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.extensions.tracing.MessageTagBuilderService;
import org.axonframework.extensions.tracing.OpenTraceDispatchInterceptor;
import org.axonframework.extensions.tracing.OpenTraceHandlerInterceptor;
import org.axonframework.extensions.tracing.TracingCommandGateway;
import org.axonframework.extensions.tracing.TracingProvider;
import org.axonframework.extensions.tracing.TracingQueryGateway;
import org.axonframework.extensions.tracing.autoconfig.SpanProperties;
import org.axonframework.extensions.tracing.autoconfig.TracingExtensionProperties;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.springboot.autoconfig.EventProcessingAutoConfiguration;
import org.axonframework.springboot.autoconfig.InfraConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={EventProcessingAutoConfiguration.class})
@AutoConfigureBefore(value={InfraConfiguration.class})
@EnableConfigurationProperties(value={TracingExtensionProperties.class, SpanProperties.class})
@ConditionalOnProperty(value={"axon.extension.tracing.enabled"}, matchIfMissing=true)
public class TracingAutoConfiguration {
    @Bean
    public OpenTraceDispatchInterceptor traceDispatchInterceptor(Tracer tracer) {
        return new OpenTraceDispatchInterceptor(tracer);
    }

    @Bean
    public OpenTraceHandlerInterceptor traceHandlerInterceptor(Tracer tracer, MessageTagBuilderService messageTagBuilderService) {
        return OpenTraceHandlerInterceptor.builder().tracer(tracer).messageTagBuilderService(messageTagBuilderService).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryGateway tracingQueryGateway(Tracer tracer, QueryBus queryBus, OpenTraceDispatchInterceptor openTraceDispatchInterceptor, OpenTraceHandlerInterceptor openTraceHandlerInterceptor, MessageTagBuilderService messageTagBuilderService) {
        queryBus.registerHandlerInterceptor((MessageHandlerInterceptor)openTraceHandlerInterceptor);
        TracingQueryGateway tracingQueryGateway = TracingQueryGateway.builder().delegateQueryBus(queryBus).tracer(tracer).messageTagBuilderService(messageTagBuilderService).build();
        tracingQueryGateway.registerDispatchInterceptor((MessageDispatchInterceptor)openTraceDispatchInterceptor);
        return tracingQueryGateway;
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandGateway tracingCommandGateway(Tracer tracer, CommandBus commandBus, OpenTraceDispatchInterceptor openTraceDispatchInterceptor, OpenTraceHandlerInterceptor openTraceHandlerInterceptor, MessageTagBuilderService messageTagBuilderService) {
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)openTraceHandlerInterceptor);
        TracingCommandGateway tracingCommandGateway = TracingCommandGateway.builder().tracer(tracer).delegateCommandBus(commandBus).messageTagBuilderService(messageTagBuilderService).build();
        tracingCommandGateway.registerDispatchInterceptor((MessageDispatchInterceptor)openTraceDispatchInterceptor);
        return tracingCommandGateway;
    }

    @Bean
    public CorrelationDataProvider tracingProvider(Tracer tracer) {
        return new TracingProvider(tracer);
    }

    @Bean
    public ConfigurerModule configureTracingInterceptor(OpenTraceHandlerInterceptor openTraceHandlerInterceptor) {
        return configurer -> configurer.eventProcessing().registerDefaultHandlerInterceptor((configuration, name) -> openTraceHandlerInterceptor);
    }

    @Bean
    public MessageTagBuilderService spanBuilderService(SpanProperties spanProperties) {
        return MessageTagBuilderService.builder().commandMessageTags(spanProperties.getCommandTags()).eventMessageTags(spanProperties.getEventTags()).queryMessageTags(spanProperties.getQueryTags()).build();
    }
}

