/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.propagation.TextMap;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.axonframework.messaging.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapExtractor
implements TextMap {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, String> extracted = new HashMap<String, String>();

    public MapExtractor(MetaData metaData) {
        metaData.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof String) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Extracting metadata entry: {}", entry);
                }
                this.extracted.put((String)entry.getKey(), (String)entry.getValue());
            }
        });
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.extracted.entrySet().iterator();
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("The iterator() method should only be used with Tracer.extract()");
    }
}

