/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Tracer;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.tracing.MessageTag;
import org.axonframework.extensions.tracing.MessageTagBuilder;
import org.axonframework.extensions.tracing.SpanUtils;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTagBuilderService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageTagBuilder commandMessageTags;
    private final MessageTagBuilder eventMessageTags;
    private final MessageTagBuilder queryMessageTags;

    public static Builder builder() {
        return new Builder();
    }

    public static MessageTagBuilderService defaultService() {
        return MessageTagBuilderService.builder().build();
    }

    protected MessageTagBuilderService(Builder builder) {
        this.commandMessageTags = builder.commandMessageTags;
        this.eventMessageTags = builder.eventMessageTags;
        this.queryMessageTags = builder.queryMessageTags;
    }

    private static Tracer.SpanBuilder withMessageId(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        return spanBuilder.withTag(MessageTag.MESSAGE_ID.getTagKey(), message.getIdentifier());
    }

    private static Tracer.SpanBuilder withAggregateId(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        if (message instanceof DomainEventMessage) {
            return spanBuilder.withTag(MessageTag.AGGREGATE_ID.getTagKey(), ((DomainEventMessage)message).getAggregateIdentifier());
        }
        return spanBuilder;
    }

    private static Tracer.SpanBuilder withMessageType(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        return spanBuilder.withTag(MessageTag.MESSAGE_TYPE.getTagKey(), SpanUtils.resolveMessageType(message));
    }

    private static Tracer.SpanBuilder withPayloadType(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        return spanBuilder.withTag(MessageTag.PAYLOAD_TYPE.getTagKey(), message.getPayloadType().getName());
    }

    private static Tracer.SpanBuilder withMessageName(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        return spanBuilder.withTag(MessageTag.MESSAGE_NAME.getTagKey(), SpanUtils.messageName(message));
    }

    private static Tracer.SpanBuilder withPayload(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        return spanBuilder.withTag(MessageTag.PAYLOAD.getTagKey(), message.getPayload().toString());
    }

    public Tracer.SpanBuilder withMessageTags(Tracer.SpanBuilder spanBuilder, Message<?> message) {
        if (message instanceof CommandMessage) {
            return this.withCommandMessageTags(spanBuilder, (CommandMessage)message);
        }
        if (message instanceof EventMessage) {
            return this.withEventMessageTags(spanBuilder, (EventMessage)message);
        }
        if (message instanceof QueryMessage) {
            return this.withQueryMessageTags(spanBuilder, (QueryMessage)message);
        }
        logger.warn("Message of type [{}] cannot be handled", message.getClass());
        return spanBuilder;
    }

    public Tracer.SpanBuilder withCommandMessageTags(Tracer.SpanBuilder spanBuilder, CommandMessage<?> commandMessage) {
        return this.commandMessageTags.build(spanBuilder, (Message<?>)commandMessage);
    }

    public Tracer.SpanBuilder withEventMessageTags(Tracer.SpanBuilder spanBuilder, EventMessage<?> eventMessage) {
        return this.eventMessageTags.build(spanBuilder, (Message<?>)eventMessage);
    }

    public Tracer.SpanBuilder withQueryMessageTags(Tracer.SpanBuilder spanBuilder, QueryMessage<?, ?> queryMessage) {
        return this.queryMessageTags.build(spanBuilder, (Message<?>)queryMessage);
    }

    public static class Builder {
        private static final MessageTagBuilder MESSAGE_ID = (x$0, x$1) -> MessageTagBuilderService.access$900(x$0, x$1);
        private static final MessageTagBuilder AGGREGATE_ID = (x$0, x$1) -> MessageTagBuilderService.access$800(x$0, x$1);
        private static final MessageTagBuilder MESSAGE_TYPE = (x$0, x$1) -> MessageTagBuilderService.access$700(x$0, x$1);
        private static final MessageTagBuilder PAYLOAD_TYPE = (x$0, x$1) -> MessageTagBuilderService.access$600(x$0, x$1);
        private static final MessageTagBuilder MESSAGE_NAME = (x$0, x$1) -> MessageTagBuilderService.access$500(x$0, x$1);
        private static final MessageTagBuilder PAYLOAD = (x$0, x$1) -> MessageTagBuilderService.access$400(x$0, x$1);
        private MessageTagBuilder commandMessageTags = (spanBuilder, message) -> MessageTagBuilder.builder().with(MESSAGE_ID).with(MESSAGE_TYPE).with(PAYLOAD_TYPE).with(MESSAGE_NAME).build((Tracer.SpanBuilder)spanBuilder, (Message<?>)message);
        private MessageTagBuilder eventMessageTags = (spanBuilder, message) -> MessageTagBuilder.builder().with(MESSAGE_ID).with(AGGREGATE_ID).with(MESSAGE_TYPE).with(PAYLOAD_TYPE).build((Tracer.SpanBuilder)spanBuilder, (Message<?>)message);
        private MessageTagBuilder queryMessageTags = (spanBuilder, message) -> MessageTagBuilder.builder().with(MESSAGE_ID).with(MESSAGE_TYPE).with(PAYLOAD_TYPE).with(MESSAGE_NAME).build((Tracer.SpanBuilder)spanBuilder, (Message<?>)message);

        public Builder commandMessageTags(MessageTag ... commandMessageTags) {
            return this.commandMessageTags(Arrays.asList(commandMessageTags));
        }

        public Builder commandMessageTags(List<MessageTag> commandMessageTags) {
            return this.commandMessageTags(this.constructMessageTagBuilder(commandMessageTags));
        }

        public Builder commandMessageTags(MessageTagBuilder commandMessageTagBuilder) {
            BuilderUtils.assertNonNull((Object)commandMessageTagBuilder, (String)"The commandMessageTagBuilder builder may not be null");
            this.commandMessageTags = commandMessageTagBuilder;
            return this;
        }

        public Builder eventMessageTags(MessageTag ... eventMessageTags) {
            return this.eventMessageTags(Arrays.asList(eventMessageTags));
        }

        public Builder eventMessageTags(List<MessageTag> eventMessageTags) {
            return this.eventMessageTags(this.constructMessageTagBuilder(eventMessageTags));
        }

        public Builder eventMessageTags(MessageTagBuilder eventMessageTagBuilder) {
            BuilderUtils.assertNonNull((Object)eventMessageTagBuilder, (String)"The eventMessageTagBuilder builder may not be null");
            this.eventMessageTags = eventMessageTagBuilder;
            return this;
        }

        public Builder queryMessageTags(MessageTag ... queryMessageTags) {
            return this.queryMessageTags(Arrays.asList(queryMessageTags));
        }

        public Builder queryMessageTags(List<MessageTag> queryMessageTags) {
            return this.queryMessageTags(this.constructMessageTagBuilder(queryMessageTags));
        }

        public Builder queryMessageTags(MessageTagBuilder queryMessageTagBuilder) {
            BuilderUtils.assertNonNull((Object)queryMessageTagBuilder, (String)"The queryMessageTagBuilder builder may not be null");
            this.queryMessageTags = queryMessageTagBuilder;
            return this;
        }

        private MessageTagBuilder constructMessageTagBuilder(List<MessageTag> messageTags) {
            MessageTagBuilder messageTagBuilder = MessageTagBuilder.builder();
            block8: for (MessageTag messageTag : messageTags) {
                switch (messageTag) {
                    case MESSAGE_ID: {
                        messageTagBuilder = messageTagBuilder.with(MESSAGE_ID);
                        continue block8;
                    }
                    case AGGREGATE_ID: {
                        messageTagBuilder = messageTagBuilder.with(AGGREGATE_ID);
                        continue block8;
                    }
                    case MESSAGE_TYPE: {
                        messageTagBuilder = messageTagBuilder.with(MESSAGE_TYPE);
                        continue block8;
                    }
                    case PAYLOAD_TYPE: {
                        messageTagBuilder = messageTagBuilder.with(PAYLOAD_TYPE);
                        continue block8;
                    }
                    case MESSAGE_NAME: {
                        messageTagBuilder = messageTagBuilder.with(MESSAGE_NAME);
                        continue block8;
                    }
                    case PAYLOAD: {
                        messageTagBuilder = messageTagBuilder.with(PAYLOAD);
                        continue block8;
                    }
                }
                logger.warn("Unknown MessageTag [{}] used.", (Object)messageTag);
            }
            return messageTagBuilder;
        }

        public MessageTagBuilderService build() {
            return new MessageTagBuilderService(this);
        }
    }
}

