/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.axonframework.extensions.tracing.MapInjector;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;

public class OpenTraceDispatchInterceptor
implements MessageDispatchInterceptor<Message<?>> {
    private final Tracer tracer;

    public OpenTraceDispatchInterceptor(Tracer tracer) {
        this.tracer = tracer;
    }

    public BiFunction<Integer, Message<?>, Message<?>> handle(List<? extends Message<?>> messages) {
        ScopeManager scopeManager = this.tracer.scopeManager();
        Optional<SpanContext> spanContextOptional = Optional.ofNullable(scopeManager).map(ScopeManager::activeSpan).map(Span::context);
        return spanContextOptional.map(spanContext -> (index, message) -> {
            MapInjector injector = new MapInjector();
            this.tracer.inject(spanContext, Format.Builtin.TEXT_MAP, (Object)injector);
            return message.andMetaData(injector.getMetaData());
        }).orElseGet(() -> (i, m) -> m);
    }
}

