/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.tracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.tracing.MapExtractor;
import org.axonframework.extensions.tracing.MessageTagBuilderService;
import org.axonframework.extensions.tracing.SpanUtils;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTraceHandlerInterceptor
implements MessageHandlerInterceptor<Message<?>> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;
    private final MessageTagBuilderService messageTagBuilderService;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public OpenTraceHandlerInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.messageTagBuilderService = MessageTagBuilderService.defaultService();
    }

    protected OpenTraceHandlerInterceptor(Builder builder) {
        builder.validate();
        this.tracer = builder.tracer;
        this.messageTagBuilderService = builder.messageTagBuilderService;
    }

    public Object handle(UnitOfWork unitOfWork, InterceptorChain interceptorChain) throws Exception {
        Message message = unitOfWork.getMessage();
        String operationName = "handle_" + SpanUtils.messageName(message);
        Tracer.SpanBuilder spanBuilder = this.getParentSpan(message).map(parentSpan -> this.tracer.buildSpan(operationName).asChildOf(parentSpan)).orElseGet(() -> this.tracer.buildSpan(operationName));
        Span span = this.messageTagBuilderService.withMessageTags(spanBuilder, unitOfWork.getMessage()).withTag(Tags.SPAN_KIND.getKey(), "server").start();
        try (Scope ignored = this.tracer.activateSpan(span);){
            unitOfWork.onCleanup(u -> span.finish());
            Object object = interceptorChain.proceed();
            return object;
        }
    }

    private Optional<SpanContext> getParentSpan(Message<?> message) {
        MetaData metaData = message.getMetaData();
        MapExtractor extractor = new MapExtractor(metaData);
        try {
            return Optional.ofNullable(this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)extractor));
        }
        catch (IllegalArgumentException ex) {
            logger.error("Corrupted parent span", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static class Builder {
        private Tracer tracer;
        private MessageTagBuilderService messageTagBuilderService = MessageTagBuilderService.defaultService();

        public Builder tracer(Tracer tracer) {
            BuilderUtils.assertNonNull((Object)tracer, (String)"Tracer may not be null");
            this.tracer = tracer;
            return this;
        }

        public Builder messageTagBuilderService(MessageTagBuilderService messageTagBuilderService) {
            BuilderUtils.assertNonNull((Object)messageTagBuilderService, (String)"MessageTagBuilderService may not be null");
            this.messageTagBuilderService = messageTagBuilderService;
            return this;
        }

        public OpenTraceHandlerInterceptor build() {
            return new OpenTraceHandlerInterceptor(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.tracer, (String)"The Tracer is a hard requirement and should be provided");
        }
    }
}

